/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.platform;

import it.crystalnest.cobweb.api.pack.fixed.StaticResourcePack;
import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.platform.services.RegistryHelper;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NeoForgeRegistryHelper
extends RegistryHelper<Register<?>> {
    private IEventBus bus = null;

    @Override
    public <R> Register<R> of(ResourceKey<? extends Registry<R>> registryKey, String namespace) {
        return this.registries.computeIfAbsent(namespace, key -> new HashMap()).computeIfAbsent(registryKey.location(), key -> {
            Register register = Register.create(registryKey, namespace);
            register.register(this.bus);
            return register;
        });
    }

    @Override
    public void registerDynamicResourcePack(PackType type, Supplier<Pack> supplier) {
        this.bus.addListener(event -> {
            if (event.getPackType() == type) {
                event.addRepositorySource(arg_0 -> NeoForgeRegistryHelper.lambda$registerDynamicResourcePack$2((Supplier)supplier, arg_0));
            }
        });
    }

    @Override
    public void registerStaticResourcePack(StaticResourcePack pack) {
        this.bus.addListener(event -> event.addPackFinders(pack.location(), pack.type(), pack.name(), pack.source(), pack.alwaysActive(), pack.position()));
    }

    private <R, T extends Register<R>> T of(Function<String, T> constructor, ResourceKey<? extends Registry<R>> registryKey, String namespace) {
        return (T)this.registries.computeIfAbsent(namespace, key -> new HashMap()).computeIfAbsent(registryKey.location(), key -> {
            Register register = (Register)constructor.apply(namespace);
            register.register(this.bus);
            return register;
        });
    }

    public void register(IEventBus bus) {
        this.bus = bus;
    }

    private static /* synthetic */ void lambda$registerDynamicResourcePack$2(Supplier supplier, Consumer consumer) {
        consumer.accept((Pack)supplier.get());
    }

    public static final class Register<R>
    implements CobwebRegister<R> {
        private final DeferredRegister<R> register;

        private Register(ResourceKey<? extends Registry<R>> registryKey, String namespace) {
            this.register = DeferredRegister.create(registryKey, (String)namespace);
        }

        public static <R> Register<R> create(ResourceKey<? extends Registry<R>> registryKey, String namespace) {
            return new Register<R>(registryKey, namespace);
        }

        public void register(IEventBus bus) {
            this.register.register(bus);
        }

        @Override
        public <T extends R> CobwebEntry<T> register(String name, Supplier<? extends T> supplier) {
            return new CobwebEntry(this.register.register(name, supplier));
        }
    }
}

