/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.interdimensionalwirelesstransmitter.common.interdimensionalwirelesstransmitter;

import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

class TransmittingIcon {
    private static final int WIDTH_0 = 11;
    private static final int WIDTH_3 = 20;
    private static final int TRANSMITTING_FRAMES = 20;
    private static final ResourceLocation NOT_TRANSMITTING = IdentifierUtil.createIdentifier((String)"transmitting/0");
    private static final ResourceLocation TRANSMITTING_1 = IdentifierUtil.createIdentifier((String)"transmitting/1");
    private static final ResourceLocation TRANSMITTING_2 = IdentifierUtil.createIdentifier((String)"transmitting/2");
    private static final ResourceLocation TRANSMITTING_3 = IdentifierUtil.createIdentifier((String)"transmitting/3");
    private int frames;
    private int cycle;
    private boolean active;

    TransmittingIcon(boolean active) {
        this.active = active;
    }

    void tick(boolean newActive) {
        this.active = newActive;
        this.doTick();
    }

    private void doTick() {
        if (!this.active) {
            this.frames = 0;
            this.cycle = 0;
            return;
        }
        ++this.frames;
        if (this.frames == 20) {
            this.frames = 0;
            ++this.cycle;
        }
    }

    void render(GuiGraphics graphics, int x3, int y3) {
        if (!this.active) {
            graphics.blitSprite(NOT_TRANSMITTING, x3, y3 + 4, 11, 4);
            return;
        }
        int frame = this.cycle % 3;
        switch (frame) {
            case 1: {
                graphics.blitSprite(TRANSMITTING_2, x3, y3 + 1, 17, 10);
                break;
            }
            case 2: {
                graphics.blitSprite(TRANSMITTING_3, x3, y3, 20, 12);
                break;
            }
            default: {
                graphics.blitSprite(TRANSMITTING_1, x3, y3 + 3, 14, 6);
            }
        }
    }

    int getWidth() {
        return this.active ? 20 : 11;
    }
}

