/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigCallback;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class ConfigSyncManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static final Map<ResourceLocation, ConfigTag> SYNC_MAP = new HashMap<ResourceLocation, ConfigTag>();

    public static void registerSync(ResourceLocation key, ConfigTag tag) {
        ConfigTag prev = SYNC_MAP.put(key, tag);
        if (prev != null) {
            throw new IllegalArgumentException("Key '" + String.valueOf(key) + "' already registered.");
        }
    }

    @ApiStatus.Internal
    public static void init(IEventBus modBus) {
        LOCK.lock();
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.addListener(ConfigSyncManager::onClientDisconnected);
        }
        modBus.addListener(ConfigSyncManager::onGameConfigurationEvent);
    }

    @ApiStatus.Internal
    public static void readSyncPacket(PacketCustom packet) {
        int numPackets = packet.readVarInt();
        for (int i = 0; i < numPackets; ++i) {
            ResourceLocation ident = packet.readResourceLocation();
            LOGGER.info("Applying config sync for {}.", (Object)ident);
            ConfigTag config = SYNC_MAP.get(ident);
            if (config == null) {
                LOGGER.fatal("Client is missing sync tag: {}. Potentially skipped other configs!", (Object)ident);
                return;
            }
            config.read(packet);
            config.runSync(ConfigCallback.Reason.SYNC);
        }
    }

    private static void onClientDisconnected(ClientPlayerNetworkEvent.LoggingOut event) {
        for (Map.Entry<ResourceLocation, ConfigTag> entry : SYNC_MAP.entrySet()) {
            LOGGER.info("Client disconnected, rolling back config for {}.", (Object)entry.getKey());
            ConfigTag config = entry.getValue();
            config.resetFromNetwork();
            config.runSync(ConfigCallback.Reason.ROLLBACK);
        }
    }

    private static void onGameConfigurationEvent(RegisterConfigurationTasksEvent event) {
        event.register((ConfigurationTask)new ConfigSyncConfigurationTask(event.getListener()));
    }

    private record ConfigSyncConfigurationTask(ServerConfigurationPacketListener listener) implements ICustomConfigurationTask
    {
        private static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(ResourceLocation.fromNamespaceAndPath((String)"codechickenlib", (String)"config_sync"));

        public void run(Consumer<CustomPacketPayload> sender) {
            if (!SYNC_MAP.isEmpty()) {
                PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 1, null);
                packet.writeVarInt(SYNC_MAP.size());
                for (Map.Entry<ResourceLocation, ConfigTag> entry : SYNC_MAP.entrySet()) {
                    packet.writeResourceLocation(entry.getKey());
                    entry.getValue().write(packet);
                }
                String mods = Joiner.on((String)", ").join(SYNC_MAP.keySet());
                LOGGER.info("Sending config sync packet for {} to connecting player.", (Object)mods);
                sender.accept(packet.toCustomPayload());
            }
            this.listener.finishCurrentTask(TYPE);
        }

        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }
}

