/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigValue;
import codechicken.lib.math.MathHelper;
import java.util.function.Predicate;

public interface Restriction
extends Predicate<ConfigValue> {
    @Override
    public boolean test(ConfigValue var1);

    public String describe();

    public static Restriction intRange(int min, int max) {
        return new IntRange(min, max);
    }

    public static Restriction doubleRange(double min, double max) {
        return new DoubleRange(min, max);
    }

    public record IntRange(int min, int max) implements Restriction
    {
        public IntRange {
            if (min > max) {
                throw new IllegalArgumentException("Min cannot be larger than max.");
            }
        }

        @Override
        public boolean test(ConfigValue configValue) {
            return MathHelper.between(this.min, configValue.getInt(), this.max);
        }

        @Override
        public String describe() {
            return "[ " + this.min + " ~ " + this.max + " ]";
        }
    }

    public record DoubleRange(double min, double max) implements Restriction
    {
        public DoubleRange {
            if (min > max) {
                throw new IllegalArgumentException("Min cannot be larger than max.");
            }
        }

        @Override
        public boolean test(ConfigValue configValue) {
            return MathHelper.between(this.min, configValue.getDouble(), this.max);
        }

        @Override
        public String describe() {
            return "[ " + this.min + " ~ " + this.max + " ]";
        }
    }
}

