/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.RecipeBuilder;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public abstract class AbstractRecipeBuilder<R, T extends AbstractRecipeBuilder<R, T>>
implements RecipeBuilder {
    protected final Throwable created = new Throwable("Created at");
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();
    protected final List<ICondition> conditions = new LinkedList<ICondition>();
    protected final ResourceLocation id;
    protected final R result;
    private final Set<ItemLike> criteriaItems = new HashSet<ItemLike>();
    private final Set<TagKey<Item>> criteriaTags = new HashSet<TagKey<Item>>();
    private int criteriaCounter = 0;
    protected boolean generateCriteria = false;
    protected boolean enableUnlocking = false;
    protected String group = "";

    protected AbstractRecipeBuilder(ResourceLocation id, R result) {
        this.id = id;
        this.result = result;
    }

    protected T getThis() {
        return (T)((AbstractRecipeBuilder)SneakyUtils.unsafeCast((Object)this));
    }

    public T withCondition(ICondition cond) {
        this.conditions.add(cond);
        return this.getThis();
    }

    public T enableUnlocking() {
        this.enableUnlocking = true;
        return this.getThis();
    }

    public T autoCriteria() {
        this.enableUnlocking();
        this.generateCriteria = true;
        return this.getThis();
    }

    public T setGroup(String group) {
        this.group = group;
        return this.getThis();
    }

    public T addCriterion(String name, Criterion<?> criterion) {
        if (!this.enableUnlocking) {
            throw new IllegalStateException("Recipe unlocking must be enabled with 'enableUnlocking'");
        }
        this.advancementBuilder.addCriterion(name, criterion);
        return this.getThis();
    }

    @Override
    public final ResourceLocation getId() {
        return this.id;
    }

    @Override
    public final RecipeBuilder.BuiltRecipe build() {
        AdvancementHolder advancement;
        this.validate();
        if (this.enableUnlocking) {
            this.advancementBuilder.parent(ResourceLocation.withDefaultNamespace((String)"recipes/root")).addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)this.id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)this.id)).requirements(AdvancementRequirements.Strategy.OR);
        }
        if ((advancement = this.advancementBuilder.build(this.id.withPrefix("recipes"))).value().criteria().isEmpty()) {
            advancement = null;
        }
        return new RecipeBuilder.BuiltRecipe(this._build(), advancement, this.conditions);
    }

    protected void validate() {
    }

    protected abstract Recipe<?> _build();

    protected void addAutoCriteria(ItemLike item) {
        if (this.generateCriteria && this.criteriaItems.add(item)) {
            this.addCriterion("has_ingredient_" + this.criteriaCounter++, this.hasItem(item));
        }
    }

    protected void addAutoCriteria(TagKey<Item> tag) {
        if (this.generateCriteria && this.criteriaTags.add(tag)) {
            this.addCriterion("has_ingredient_" + this.criteriaCounter++, this.hasItem(tag));
        }
    }

    protected Criterion<?> hasItem(ItemLike itemIn) {
        return this.hasItem(ItemPredicate.Builder.item().of(new ItemLike[]{itemIn}).build());
    }

    protected Criterion<?> hasItem(TagKey<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.item().of(tagIn).build());
    }

    protected Criterion<?> hasItem(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }
}

