/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.geometry;

import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.function.Supplier;

public interface Position {
    public double x();

    public double y();

    default public Position offset(double x, double y) {
        return Position.create(this.x() + x, this.y() + y);
    }

    default public double get(Axis axis) {
        return axis == Axis.X ? this.x() : this.y();
    }

    public static Position create(double x, double y) {
        return new Immutable(x, y);
    }

    public static Position create(Supplier<Double> getX, Supplier<Double> getY) {
        return new Dynamic(getX, getY);
    }

    public static Position create(GuiParent<?> parent) {
        return new Dynamic(parent::xMin, parent::yMin);
    }

    public record Immutable(double x, double y) implements Position
    {
    }

    public record Dynamic(Supplier<Double> getX, Supplier<Double> getY) implements Position
    {
        @Override
        public double x() {
            return this.getX.get();
        }

        @Override
        public double y() {
            return this.getY.get();
        }

        @Override
        public String toString() {
            return "Dynamic{x=" + this.x() + ", y=" + this.y() + "}";
        }
    }

    public static class Mutable
    implements Position {
        private double x;
        private double y;

        public Mutable(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double x() {
            return this.x;
        }

        @Override
        public double y() {
            return this.y;
        }

        @Override
        public Position offset(double x, double y) {
            this.x += x;
            this.y += y;
            return this;
        }

        public Position set(double x, double y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public String toString() {
            return "Mutable{x=" + this.x() + ", y=" + this.y() + "}";
        }
    }
}

