/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import org.jetbrains.annotations.Nullable;

public class KillAllCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"killall").requires(e -> e.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).executes(ctx -> {
            EntityType entityType = (EntityType)ResourceArgument.getEntityType((CommandContext)ctx, (String)"entity").value();
            return KillAllCommand.killallForce((CommandContext<CommandSourceStack>)ctx, entityType, e -> Objects.equals(e.getType(), entityType));
        }))).executes(ctx -> KillAllCommand.killallForce((CommandContext<CommandSourceStack>)ctx, null, e -> e instanceof Enemy))).then(((LiteralArgumentBuilder)Commands.literal((String)"gracefully").then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).executes(ctx -> {
            EntityType entityType = (EntityType)ResourceArgument.getEntityType((CommandContext)ctx, (String)"entity").value();
            return KillAllCommand.killAllGracefully((CommandContext<CommandSourceStack>)ctx, entityType, e -> Objects.equals(e.getType(), entityType));
        }))).executes(ctx -> KillAllCommand.killAllGracefully((CommandContext<CommandSourceStack>)ctx, null, e -> e instanceof Enemy)))));
    }

    private static int killAllGracefully(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate) {
        return KillAllCommand.killEntities(ctx, type, predicate, Entity::kill);
    }

    private static int killallForce(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate) {
        return KillAllCommand.killEntities(ctx, type, predicate, Entity::discard);
    }

    private static int killEntities(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate, Consumer<Entity> killFunc) {
        if (type == EntityType.PLAYER) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.killall.fail.player").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel world = source.getLevel();
        ServerChunkCache provider = world.getChunkSource();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        ArrayList entities = FastStream.of((Iterable)world.getEntities().getAll()).filter(Objects::nonNull).filter(predicate).filter(e -> provider.hasChunk(MathHelper.floor(e.getX()) >> 4, MathHelper.floor(e.getZ()) >> 4)).toList();
        for (Entity e2 : entities) {
            killFunc.accept(e2);
            int count = counts.getInt((Object)e2.getType());
            counts.put((Object)e2.getType(), count + 1);
        }
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType t : order) {
            int count = counts.getInt((Object)t);
            String name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)t).toString();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.killall.success.line", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + name + String.valueOf(ChatFormatting.RESET) + " x " + String.valueOf(ChatFormatting.AQUA) + count}), false);
            total += count;
        }
        if (order.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.killall.fail"), false);
        } else if (order.size() > 1) {
            int finalTotal = total;
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.killall.success", (Object[])new Object[]{ChatFormatting.AQUA.toString() + finalTotal + String.valueOf(ChatFormatting.RESET)}), false);
        }
        return total;
    }
}

