/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class CustomBreakingParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;

    public CustomBreakingParticle(ClientLevel world, double x, double y, double z, double dx, double dy, double dz, TextureAtlasSprite icon) {
        super(world, x, y, z, dx, dy, dz);
        this.setSprite(icon);
        this.gravity = 1.0f;
        this.bCol = 0.6f;
        this.gCol = 0.6f;
        this.rCol = 0.6f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
    }

    public static CustomBreakingParticle newLandingParticle(ClientLevel world, double x, double y, double z, double dx, double dy, double dz, TextureAtlasSprite icon) {
        CustomBreakingParticle particle = new CustomBreakingParticle(world, x, y, z, dx, dy, dz, icon);
        particle.xd = dx;
        particle.yd = dy;
        particle.zd = dz;
        return particle;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    public void setScale(float scale) {
        this.quadSize = scale;
    }

    public float getScale() {
        return this.quadSize;
    }
}

