/*
 * Decompiled with CFR 0.152.
 */
package guideme.color;

import guideme.color.ColorValue;
import guideme.color.LightDarkMode;
import guideme.color.MutableColor;

public class LightnessFunction
implements ColorValue {
    private final ColorValue color;
    private final float percentage;

    public LightnessFunction(ColorValue color, float percentage) {
        this.color = color;
        this.percentage = percentage;
    }

    @Override
    public int resolve(LightDarkMode lightDarkMode) {
        MutableColor mutableColor = MutableColor.of(this.color, lightDarkMode);
        if (this.percentage < 0.0f) {
            mutableColor.darker(-this.percentage);
        } else if (this.percentage > 0.0f) {
            mutableColor.lighter(this.percentage);
        }
        return mutableColor.toArgb32();
    }
}

