/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.cjk;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.cjk.CJKBigramFilter;
import java.util.Map;

public class CJKBigramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "cjkBigram";
    final int flags;
    final boolean outputUnigrams;

    public CJKBigramFilterFactory(Map<String, String> args) {
        super(args);
        int flags = 0;
        if (this.getBoolean(args, "han", true)) {
            flags |= 1;
        }
        if (this.getBoolean(args, "hiragana", true)) {
            flags |= 2;
        }
        if (this.getBoolean(args, "katakana", true)) {
            flags |= 4;
        }
        if (this.getBoolean(args, "hangul", true)) {
            flags |= 8;
        }
        this.flags = flags;
        this.outputUnigrams = this.getBoolean(args, "outputUnigrams", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public CJKBigramFilterFactory() {
        throw CJKBigramFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new CJKBigramFilter(input, this.flags, this.outputUnigrams);
    }
}

