/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.intervals;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.queries.intervals.ConjunctionMatchesIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalMatches;
import guideme.internal.shaded.lucene.queries.intervals.IntervalMatchesIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalQuery;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class ConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;

    protected ConjunctionIntervalsSource(List<IntervalsSource> subSources) {
        assert (subSources.size() > 1);
        this.subSources = subSources;
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field, v);
        }
    }

    @Override
    public final IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.combine(subIntervals);
    }

    protected abstract IntervalIterator combine(List<IntervalIterator> var1);

    protected IntervalMatchesIterator createMatchesIterator(IntervalIterator it, List<IntervalMatchesIterator> subs) {
        return new ConjunctionMatchesIterator(it, subs);
    }

    @Override
    public final IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<IntervalMatchesIterator> subs = new ArrayList<IntervalMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalMatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(mi);
        }
        IntervalIterator it = this.combine(subs.stream().map(m -> IntervalMatches.wrapMatches(m, doc)).toList());
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return this.createMatchesIterator(it, subs);
    }
}

