/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.store.FSDirectory;
import guideme.internal.shaded.lucene.store.FSLockFactory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.LockFactory;
import guideme.internal.shaded.lucene.store.ReadAdvice;
import guideme.internal.shaded.lucene.util.Constants;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Logger;

public class MMapDirectory
extends FSDirectory {
    public static final BiPredicate<String, IOContext> ALL_FILES = (filename, context) -> true;
    public static final BiPredicate<String, IOContext> NO_FILES = (filename, context) -> false;
    public static final String SHARED_ARENA_MAX_PERMITS_SYSPROP = "guideme.internal.shaded.lucene.store.MMapDirectory.sharedArenaMaxPermits";
    public static final Function<String, Optional<String>> NO_GROUPING = filename -> Optional.empty();
    public static final Function<String, Optional<String>> GROUP_BY_SEGMENT = filename -> {
        if (!IndexFileNames.CODEC_FILE_PATTERN.matcher((CharSequence)filename).matches()) {
            return Optional.empty();
        }
        Object groupKey = IndexFileNames.parseSegmentName(filename).substring(1);
        try {
            if (IndexFileNames.parseGeneration(filename) > 0L) {
                groupKey = (String)groupKey + "-g";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.of(groupKey);
    };
    public static final BiPredicate<String, IOContext> BASED_ON_LOAD_IO_CONTEXT = (filename, context) -> context.readAdvice() == ReadAdvice.RANDOM_PRELOAD;
    private BiPredicate<String, IOContext> preload = NO_FILES;
    public static final long DEFAULT_MAX_CHUNK_SIZE;
    final Object attachment = PROVIDER.attachment();
    private Function<String, Optional<String>> groupingFunction = GROUP_BY_SEGMENT;
    final int chunkSizePower;
    static final MMapIndexInputProvider<Object> PROVIDER;

    public MMapDirectory(Path path, LockFactory lockFactory) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    public MMapDirectory(Path path, long maxChunkSize) throws IOException {
        this(path, FSLockFactory.getDefault(), maxChunkSize);
    }

    public MMapDirectory(Path path, LockFactory lockFactory, long maxChunkSize) throws IOException {
        super(path, lockFactory);
        if (maxChunkSize <= 0L) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 63 - Long.numberOfLeadingZeros(maxChunkSize);
        assert (1L << this.chunkSizePower <= maxChunkSize);
        assert (1L << this.chunkSizePower > maxChunkSize / 2L);
    }

    public void setPreload(BiPredicate<String, IOContext> preload) {
        this.preload = preload;
    }

    public void setGroupingFunction(Function<String, Optional<String>> groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public final long getMaxChunkSize() {
        return 1L << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        return PROVIDER.openInput(path, context, this.chunkSizePower, this.preload.test(name, context), this.groupingFunction.apply(name), this.attachment);
    }

    private static int getSharedArenaMaxPermitsSysprop() {
        int ret = 1024;
        try {
            String str = System.getProperty(SHARED_ARENA_MAX_PERMITS_SYSPROP);
            if (str != null) {
                ret = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException | SecurityException ignored) {
            Logger.getLogger(MMapDirectory.class.getName()).warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, so the default value will be used.");
        }
        return ret;
    }

    private static <A> MMapIndexInputProvider<A> lookupProvider() {
        int maxPermits = MMapDirectory.getSharedArenaMaxPermitsSysprop();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> cls = lookup.findClass("guideme.internal.shaded.lucene.store.MemorySegmentIndexInputProvider");
            MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Integer.TYPE));
            try {
                return constr.invoke(maxPermits);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable th) {
                throw new AssertionError((Object)th);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("MemorySegmentIndexInputProvider is missing correctly typed constructor", e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new LinkageError("MemorySegmentIndexInputProvider is missing in Lucene JAR file", cnfe);
        }
    }

    public static boolean supportsMadvise() {
        return PROVIDER.supportsMadvise();
    }

    static {
        PROVIDER = MMapDirectory.lookupProvider();
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
    }

    static interface MMapIndexInputProvider<A> {
        public IndexInput openInput(Path var1, IOContext var2, int var3, boolean var4, Optional<String> var5, A var6) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean supportsMadvise();

        default public A attachment() {
            return null;
        }

        default public IOException convertMapFailedIOException(IOException ioe, String resourceDescription, long bufSize) {
            Throwable originalCause;
            String originalMessage;
            if (ioe.getCause() instanceof OutOfMemoryError) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: https://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
            newIoe.setStackTrace(ioe.getStackTrace());
            return newIoe;
        }
    }
}

