/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_polymorphia.mixin;

import com.hollingsworth.arsnouveau.common.block.tile.CraftingLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.TransientCustomContainer;
import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.common.network.server.SPacketPlayerRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketRecipesList;
import com.illusivesoulworks.polymorph.common.util.RecipePair;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingLecternTile.class})
public abstract class CraftingLecternTileMixin {
    @Shadow
    private CraftingRecipe currentRecipe;

    @Shadow
    public abstract TransientCustomContainer getCraftingInv(UUID var1);

    @Inject(method={"onCraftingMatrixChanged"}, at={@At(value="HEAD")})
    public void onCraftMatrixChanged(UUID uuid, CallbackInfo ci) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerPlayer player = server.getPlayerList().getPlayer(uuid);
        if (player == null) {
            return;
        }
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        IPlayerRecipeData playerData = PolymorphApi.getInstance().getPlayerRecipeData((Player)player);
        RecipeHolder selected = playerData.getSelectedRecipe();
        List recipes = serverLevel.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)this.getCraftingInv(uuid).asCraftInput(), (Level)serverLevel);
        HashSet<RecipePair> pairs = new HashSet<RecipePair>();
        for (RecipeHolder recipe : recipes) {
            ItemStack result = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            if (result.isEmpty()) continue;
            pairs.add(new RecipePair(recipe.id(), result));
            if (selected == null || !recipe.id().equals((Object)selected.id())) continue;
            this.currentRecipe = (CraftingRecipe)recipe.value();
        }
        Optional<Object> selectedId = Optional.empty();
        if (selected != null) {
            selectedId = Optional.of(selected.id());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SPacketRecipesList(Optional.of(pairs), selectedId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SPacketPlayerRecipeSync(Optional.of(pairs), selectedId), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

