/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterSimilarMode;
import dev.technici4n.moderndynamics.attachment.settings.OversendingMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.client.screen.CycleSetting;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class CycleSettingButton<T>
extends Button {
    private static final int DISABLED_SETTING = 0;
    private final List<CycleSetting<T>> settings;
    private int currentSetting;
    private final BiConsumer<T, Boolean> onChange;
    private boolean advancedBehavior = false;
    public static final List<CycleSetting<FilterInversionMode>> FILTER_INVERSION = ImmutableList.of(new CycleSetting<FilterInversionMode>(FilterInversionMode.WHITELIST, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_mode.whitelist"), 176, 0), new CycleSetting<FilterInversionMode>(FilterInversionMode.BLACKLIST, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_mode.blacklist"), 196, 0));
    public static final List<CycleSetting<FilterNbtMode>> FILTER_NBT = ImmutableList.of(new CycleSetting<FilterNbtMode>(FilterNbtMode.RESPECT_NBT, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_nbt.respect_nbt"), 216, 0), new CycleSetting<FilterNbtMode>(FilterNbtMode.IGNORE_NBT, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_nbt.ignore_nbt"), 236, 0));
    public static final List<CycleSetting<FilterDamageMode>> FILTER_DAMAGE = ImmutableList.of(new CycleSetting<FilterDamageMode>(FilterDamageMode.RESPECT_DAMAGE, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_damage.respect_damage"), 176, 60), new CycleSetting<FilterDamageMode>(FilterDamageMode.IGNORE_DAMAGE, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_damage.ignore_damage"), 196, 60));
    public static final List<CycleSetting<FilterModMode>> FILTER_MOD = ImmutableList.of(new CycleSetting<FilterModMode>(FilterModMode.IGNORE_MOD, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_mod.ignore_mod"), 196, 120), new CycleSetting<FilterModMode>(FilterModMode.INCLUDE_ALL_OF_MOD, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_mod.include_all_of_mod"), 176, 120));
    public static final List<CycleSetting<FilterSimilarMode>> FILTER_SIMILAR = ImmutableList.of(new CycleSetting<FilterSimilarMode>(FilterSimilarMode.IGNORE_SIMILAR, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_similar.ignore_similar"), 236, 60), new CycleSetting<FilterSimilarMode>(FilterSimilarMode.INCLUDE_SIMILAR, (Component)Component.translatable((String)"gui.moderndynamics.setting.filter_similar.include_similar"), 216, 60));
    public static final List<CycleSetting<RoutingMode>> ROUTING_MODE = ImmutableList.of(new CycleSetting<RoutingMode>(RoutingMode.CLOSEST, (Component)Component.translatable((String)"gui.moderndynamics.setting.routing_mode.closest"), 216, 196), new CycleSetting<RoutingMode>(RoutingMode.FURTHEST, (Component)Component.translatable((String)"gui.moderndynamics.setting.routing_mode.furthest"), 20, 204), new CycleSetting<RoutingMode>(RoutingMode.RANDOM, (Component)Component.translatable((String)"gui.moderndynamics.setting.routing_mode.random"), 40, 204), new CycleSetting<RoutingMode>(RoutingMode.ROUND_ROBIN, (Component)Component.translatable((String)"gui.moderndynamics.setting.routing_mode.round_robin"), 60, 204));
    public static final List<CycleSetting<OversendingMode>> OVERSENDING_MODE = ImmutableList.of(new CycleSetting<OversendingMode>(OversendingMode.PREVENT_OVERSENDING, (Component)Component.translatable((String)"gui.moderndynamics.setting.oversending_mode.prevent_oversending"), 196, 196), new CycleSetting<OversendingMode>(OversendingMode.ALLOW_OVERSENDING, (Component)Component.translatable((String)"gui.moderndynamics.setting.oversending_mode.allow_oversending"), 176, 196));
    public static final Component REQUIRES_ADVANCED_BEHAVIOR = Component.translatable((String)"gui.moderndynamics.tooltip.requires_advanced_behavior").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED));

    public CycleSettingButton(List<CycleSetting<T>> settings, T initialSetting, BiConsumer<T, Boolean> onChange) {
        super(0, 0, 20, 20, (Component)Component.empty(), button -> {}, DEFAULT_NARRATION);
        this.settings = settings;
        this.setValue(initialSetting);
        this.onChange = onChange;
    }

    public CycleSettingButton<T> requiresAdvancedBehavior() {
        this.advancedBehavior = true;
        return this;
    }

    public void setValue(T newValue) {
        for (int i = 0; i < this.settings.size(); ++i) {
            if (this.settings.get(i).value() != newValue) continue;
            this.currentSetting = i;
            break;
        }
    }

    public void onPress() {
        if (!this.isActive()) {
            return;
        }
        this.currentSetting = (this.currentSetting + 1) % this.settings.size();
        this.onChange.accept(this.getCurrentSetting().value(), true);
    }

    private CycleSetting<T> getCurrentSetting() {
        return this.settings.get(this.isActive() ? this.currentSetting : 0);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        CycleSetting<T> setting = this.getCurrentSetting();
        int y = setting.spriteY();
        if (!this.isActive()) {
            y += 40;
        } else if (this.isHovered) {
            y += 20;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blit(ItemAttachedIoScreen.TEXTURE, this.getX(), this.getY(), setting.spriteX(), y, this.width, this.height);
        if (this.isHovered) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add(setting.tooltip());
            if (this.advancedBehavior && !this.isActive()) {
                tooltip.add(REQUIRES_ADVANCED_BEHAVIOR);
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

