/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.data.PipeModelLoaderBuilder;
import dev.technici4n.moderndynamics.extender.MachineExtenderBlock;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.pipe.PipeBlock;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModelsProvider
extends BlockStateProvider {
    public ModelsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "moderndynamics", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        MachineExtenderBlock ext = MdBlocks.MACHINE_EXTENDER;
        ResourceLocation columnTexture = TextureMapping.getBlockTexture((Block)ext, (String)"_column");
        ResourceLocation sideTexture = TextureMapping.getBlockTexture((Block)ext, (String)"_side");
        ResourceLocation sideTopTexture = TextureMapping.getBlockTexture((Block)ext, (String)"_side_top");
        ResourceLocation endTexture = TextureMapping.getBlockTexture((Block)ext, (String)"_end");
        BlockModelBuilder topModel = (BlockModelBuilder)this.models().cubeBottomTop("machine_extender_top", sideTopTexture, columnTexture, endTexture);
        BlockModelBuilder normalModel = (BlockModelBuilder)this.models().cubeColumn("machine_extender_normal", sideTexture, columnTexture);
        this.getVariantBuilder(ext).partialState().with((Property)MachineExtenderBlock.TOP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topModel)}).partialState().with((Property)MachineExtenderBlock.TOP, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)normalModel)});
        this.simpleBlockItem(ext, (ModelFile)normalModel);
        for (AttachmentItem attachmentItem : MdItems.ALL_ATTACHMENTS) {
            this.itemModels().basicItem((Item)attachmentItem);
        }
        this.wrench();
        this.itemModels().basicItem((Item)MdItems.DEBUG_TOOL);
        for (PipeBlock pipeBlock : MdBlocks.ALL_PIPES) {
            String path = "block/" + pipeBlock.id;
            BlockModelBuilder model = (BlockModelBuilder)((PipeModelLoaderBuilder)((BlockModelBuilder)this.models().getBuilder(path)).customLoader(PipeModelLoaderBuilder::new)).pipeType(pipeBlock.id).transparent(pipeBlock.isTransparent()).end();
            this.itemModels().withExistingParent("item/" + pipeBlock.id, this.modLoc(path));
            this.getVariantBuilder(pipeBlock).partialState().setModels(ConfiguredModel.builder().modelFile((ModelFile)model).build());
        }
    }

    private void wrench() {
        ResourceLocation id = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)MdItems.WRENCH));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(id.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("item/" + id.getPath())));
    }
}

