/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.pipe;

import dev.technici4n.moderndynamics.pipe.PipeBlock;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.WrenchHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PipeItem
extends BlockItem {
    public PipeItem(PipeBlock block) {
        super((Block)block, new Item.Properties());
        block.setItem(this);
    }

    public PipeBlock getBlock() {
        return (PipeBlock)super.getBlock();
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        BlockEntity be;
        boolean couldPlace = super.placeBlock(context, state);
        if (!couldPlace) {
            return false;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player maybePlayer = context.getPlayer();
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            for (Direction direction : Direction.values()) {
                PipeBlockEntity adjPipe;
                BlockEntity adjBe = level.getBlockEntity(pos.relative(direction));
                if (adjBe instanceof PipeBlockEntity) {
                    adjPipe = (PipeBlockEntity)adjBe;
                    if ((adjPipe.connectionBlacklist & 1 << direction.getOpposite().get3DDataValue()) > 0) {
                        pipe.connectionBlacklist |= 1 << direction.get3DDataValue();
                    }
                }
                if (maybePlayer == null || !WrenchHelper.isWrench(maybePlayer.getOffhandItem())) continue;
                pipe.connectionBlacklist |= 1 << direction.get3DDataValue();
                if (adjBe instanceof PipeBlockEntity) {
                    adjPipe = (PipeBlockEntity)adjBe;
                    adjPipe.connectionBlacklist |= 1 << direction.getOpposite().get3DDataValue();
                    level.blockEntityChanged(adjPipe.getBlockPos());
                }
                if (!maybePlayer.isShiftKeyDown() || direction.getOpposite() != context.getClickedFace()) continue;
                pipe.connectionBlacklist ^= 1 << direction.get3DDataValue();
                if (!(adjBe instanceof PipeBlockEntity)) continue;
                adjPipe = (PipeBlockEntity)adjBe;
                adjPipe.connectionBlacklist ^= 1 << direction.getOpposite().get3DDataValue();
                level.blockEntityChanged(adjPipe.getBlockPos());
            }
        }
        return true;
    }
}

