/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.core;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    private static final ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;

    private Config() {
    }

    public static void init(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        Pair commonPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)commonPair.getRight();
        COMMON = (CommonConfig)commonPair.getLeft();
    }

    public static final class CommonConfig {
        public final ModConfigSpec.IntValue requests;
        public final ModConfigSpec.DoubleValue idleEnergy;
        public final ModConfigSpec.BooleanValue requireChannel;

        private CommonConfig(ModConfigSpec.Builder builder) {
            builder.push("requester");
            this.requests = builder.comment("The amount of requests a single ME Requester can hold.").defineInRange("requests", 5, 1, 64);
            this.idleEnergy = builder.comment("The amount of energy (in AE) the ME Requester drains from the ME network when idle.").defineInRange("idle_energy", 5.0, 0.0, Double.MAX_VALUE);
            this.requireChannel = builder.comment("Whether the ME Requester requires an ME network channel to function.").define("require_channel", true);
            builder.pop();
        }
    }
}

