/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester.status;

import appeng.api.networking.crafting.CraftingSubmitErrorCode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.ticking.TickRateModulation;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.status.CpuState;
import com.almostreliable.merequester.requester.status.LinkState;
import com.almostreliable.merequester.requester.status.MissingState;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.almostreliable.merequester.requester.status.StatusState;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class PlanState
implements StatusState {
    private static final Set<CraftingSubmitErrorCode> CPU_ERROR_CODES = Set.of(CraftingSubmitErrorCode.NO_CPU_FOUND, CraftingSubmitErrorCode.NO_SUITABLE_CPU_FOUND, CraftingSubmitErrorCode.CPU_BUSY, CraftingSubmitErrorCode.CPU_OFFLINE, CraftingSubmitErrorCode.CPU_TOO_SMALL);
    private final Future<? extends ICraftingPlan> future;

    PlanState(Future<? extends ICraftingPlan> future) {
        this.future = future;
    }

    @Override
    public StatusState handle(RequesterBlockEntity host, int index) {
        if (!this.future.isDone()) {
            return this;
        }
        if (this.future.isCancelled()) {
            return IDLE;
        }
        try {
            ICraftingPlan plan = this.future.get();
            if (!plan.missingItems().isEmpty()) {
                return new MissingState();
            }
            ICraftingSubmitResult submitResult = host.getMainNodeGrid().getCraftingService().submitJob(plan, (ICraftingRequester)host, null, false, host.getActionSource());
            ICraftingLink craftingLink = submitResult.link();
            if (!submitResult.successful() || craftingLink == null) {
                if (submitResult.errorCode() != null && CPU_ERROR_CODES.contains(submitResult.errorCode())) {
                    return new CpuState();
                }
                return IDLE;
            }
            host.getStorageManager().get(index).setTotalAmount(plan.finalOutput().amount());
            return new LinkState(craftingLink);
        }
        catch (InterruptedException | ExecutionException e) {
            return IDLE;
        }
    }

    @Override
    public RequestStatus type() {
        return RequestStatus.PLAN;
    }

    @Override
    public TickRateModulation getTickRateModulation() {
        return this.future.isDone() && !this.future.isCancelled() ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }
}

