/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.network;

import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketStorageInfoToClient(BlockPos pos, String sortMode, String viewMode, Boolean groupMode, String filter, Boolean locked) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"storageinfotoclient");
    public static final CustomPacketPayload.Type<PacketStorageInfoToClient> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketStorageInfoToClient> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketStorageInfoToClient::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketStorageInfoToClient::sortMode, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketStorageInfoToClient::viewMode, (StreamCodec)ByteBufCodecs.BOOL, PacketStorageInfoToClient::groupMode, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketStorageInfoToClient::filter, (StreamCodec)ByteBufCodecs.BOOL, PacketStorageInfoToClient::locked, PacketStorageInfoToClient::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketStorageInfoToClient create(BlockPos pos, String sortMode, String viewMode, boolean groupMode, String filter, boolean locked) {
        return new PacketStorageInfoToClient(pos, sortMode, viewMode, groupMode, filter, locked);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().getBlockEntity(this.pos);
            if (te instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storage = (ModularStorageTileEntity)te;
                storage.syncInventoryFromServer(this.sortMode, this.viewMode, this.groupMode, this.filter, this.locked);
            }
        });
    }
}

