/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.client.GuiTools;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.blocks.RemoteStorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlClientScreenModule;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class StorageControlModuleItem
extends GenericModuleItem
implements IComponentsToPreserve,
ITabletSupport {
    public Item getInstalledTablet() {
        return (Item)StorageScannerModule.TABLET_SCANNER.get();
    }

    public void openGui(@Nonnull Player player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        BlockPos pos = ModuleTools.getPositionFromModule((ItemStack)containingItem);
        ResourceKey dimensionType = ModuleTools.getDimensionFromModule((ItemStack)containingItem);
        GuiTools.openRemoteGui((Player)player, (ResourceKey)dimensionType, (BlockPos)pos, te -> new MenuProvider(){
            final /* synthetic */ BlockEntity val$te;
            final /* synthetic */ BlockPos val$pos;
            {
                this.val$te = blockEntity;
                this.val$pos = blockPos;
            }

            @Nonnull
            public Component getDisplayName() {
                return ComponentFactory.literal((String)"Remote Storage Scanner");
            }

            @Nonnull
            public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                if (this.val$te instanceof StorageScannerTileEntity) {
                    StorageScannerTileEntity scanner = (StorageScannerTileEntity)this.val$te;
                    RemoteStorageScannerContainer container = StorageScannerContainer.createRemote(id, this.val$pos, scanner, player);
                    container.setupInventories((IItemHandler)scanner.getItems(), inventory);
                    return container;
                }
                Logging.logError((String)("Cannot open remote storage scanner GUI at " + String.valueOf(this.val$pos) + " because the tile entity is not a StorageScannerTileEntity!"));
                return null;
            }
        });
    }

    protected int getUses(ItemStack stack) {
        return (Integer)StorageScannerConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public StorageControlModuleItem() {
        super(RFToolsStorage.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockEntity te = world.getBlockEntity(pos);
        StorageControlScreenModule data = StorageControlModuleItem.data(stack);
        if (te instanceof IStorageScanner) {
            data = data.withPos(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            String name = "<invalid>";
            if (block != null && !world.getBlockState(pos).isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            data = data.withPos(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID));
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Storage module is cleared");
            }
        }
        stack.set(StorageScannerModule.MODULE_CONTROL_DATA, (Object)data);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return StorageControlScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return StorageControlScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)StorageScannerModule.MODULE_CONTROL_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return StorageControlScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new StorageControlClientScreenModule();
    }

    public String getModuleName() {
        return "Stor";
    }

    public static StorageControlScreenModule data(ItemStack stack) {
        StorageControlScreenModule data = (StorageControlScreenModule)stack.get(StorageScannerModule.MODULE_CONTROL_DATA);
        if (data == null) {
            data = StorageControlScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<StorageControlScreenModule, StorageControlScreenModule> setter) {
        StorageControlScreenModule data = StorageControlModuleItem.data(stack);
        data = setter.apply(data);
        stack.set(StorageScannerModule.MODULE_CONTROL_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(0, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(0)).ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(1, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(1)).ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(2, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(2)).nl().ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(3, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(3)).ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(4, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(4)).ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(5, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(5)).nl().ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(6, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(6)).ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(7, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(7)).ghostStack((module, stack) -> StorageControlModuleItem.data(module, d -> d.withStack(8, (ItemStack)stack)), module -> StorageControlModuleItem.data(module).stacks().get(8)).nl().toggle((module, starred) -> StorageControlModuleItem.data(module, d -> d.withStarred((boolean)starred)), module -> StorageControlModuleItem.data(module).starred(), "Starred", new String[]{"If enabled only count items", "in 'starred' inventories", "(mark inventories in storage scanner)"}).block(module -> StorageControlModuleItem.data(module).pos(), module -> "").nl();
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)StorageScannerModule.MODULE_CONTROL_DATA.get());
    }
}

