/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.network.PacketReturnInventoryInfo;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGetInventoryInfo(ResourceKey<Level> levelId, BlockPos pos, boolean doscan) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"getinventoryinfo");
    public static final CustomPacketPayload.Type<PacketGetInventoryInfo> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGetInventoryInfo> CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), PacketGetInventoryInfo::levelId, (StreamCodec)BlockPos.STREAM_CODEC, PacketGetInventoryInfo::pos, (StreamCodec)ByteBufCodecs.BOOL, PacketGetInventoryInfo::doscan, PacketGetInventoryInfo::new);

    public static PacketGetInventoryInfo create(ResourceKey<Level> dimension, BlockPos storageScannerPos, boolean b) {
        return new PacketGetInventoryInfo(dimension, storageScannerPos, b);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            this.onMessageServer(player).ifPresent(p -> this.sendReplyToClient((List<PacketReturnInventoryInfo.InventoryInfo>)p, (ServerPlayer)player));
        });
    }

    private void sendReplyToClient(List<PacketReturnInventoryInfo.InventoryInfo> reply, ServerPlayer player) {
        PacketReturnInventoryInfo msg = new PacketReturnInventoryInfo(reply);
        RFToolsStorageMessages.sendToPlayer(msg, (Player)player);
    }

    private Optional<List<PacketReturnInventoryInfo.InventoryInfo>> onMessageServer(Player player) {
        ServerLevel world = LevelTools.getLevel((Level)player.level(), this.levelId);
        if (world == null) {
            return Optional.empty();
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos)) {
            return Optional.empty();
        }
        BlockEntity te = world.getBlockEntity(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scanner.findInventories() : scanner.getAllInventories();
            List invs = inventories.map(arg_0 -> PacketGetInventoryInfo.lambda$onMessageServer$2((Level)world, scanner, arg_0)).collect(Collectors.toList());
            return Optional.of(invs);
        }
        return Optional.empty();
    }

    private static PacketReturnInventoryInfo.InventoryInfo toInventoryInfo(Level world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!LevelTools.isLoaded((Level)world, (BlockPos)pos)) {
            displayName = "[UNLOADED]";
            block = null;
        } else if (world.isEmptyBlock(pos)) {
            displayName = "[REMOVED]";
            block = null;
        } else {
            displayName = Tools.getReadableName((Level)world, (BlockPos)pos);
        }
        return new PacketReturnInventoryInfo.InventoryInfo(pos, displayName, te.isRoutable(pos), block);
    }

    private static /* synthetic */ PacketReturnInventoryInfo.InventoryInfo lambda$onMessageServer$2(Level world, StorageScannerTileEntity scanner, BlockPos pos) {
        return PacketGetInventoryInfo.toInventoryInfo(world, pos, scanner);
    }
}

