/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketRequestItem(ResourceKey<Level> dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, Integer amount, Boolean craftable) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"requestitem");
    public static final CustomPacketPayload.Type<PacketRequestItem> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketRequestItem> CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), PacketRequestItem::dimensionId, (StreamCodec)BlockPos.STREAM_CODEC, PacketRequestItem::pos, (StreamCodec)BlockPos.STREAM_CODEC, PacketRequestItem::inventoryPos, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, PacketRequestItem::item, (StreamCodec)ByteBufCodecs.INT, PacketRequestItem::amount, (StreamCodec)ByteBufCodecs.BOOL, PacketRequestItem::craftable, PacketRequestItem::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketRequestItem create(ResourceKey<Level> dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, int amount, boolean craftable) {
        return new PacketRequestItem(dimensionId, pos, inventoryPos, item, amount, craftable);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ServerLevel world = LevelTools.getLevel((Level)player.level(), this.dimensionId);
            if (world == null) {
                return;
            }
            if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos)) {
                return;
            }
            BlockEntity te = world.getBlockEntity(this.pos);
            if (te instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
                if (this.craftable.booleanValue()) {
                    scanner.requestCraft(this.inventoryPos, this.item, this.amount, player);
                } else {
                    scanner.requestStack(this.inventoryPos, this.item, this.amount, player);
                }
            }
        });
    }
}

