/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StorageEntry {
    private NonNullList<ItemStack> stacks;
    private final UUID uuid;
    private int version;
    private final long creationTime;
    private long updateTime;
    private String createdBy;

    public StorageEntry(CompoundTag nbt, HolderLookup.Provider provider) {
        int size = nbt.getInt("slots");
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTags));
        }
        this.uuid = nbt.hasUUID("UUID") ? nbt.getUUID("UUID") : null;
        this.version = nbt.getInt("version");
        this.creationTime = nbt.getLong("crTime");
        this.updateTime = nbt.getLong("upTime");
        this.createdBy = nbt.getString("createdBy");
    }

    public StorageEntry(int size, UUID uuid, String createdBy) {
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.uuid = uuid;
        this.version = 1;
        this.creationTime = this.updateTime = System.currentTimeMillis();
        this.createdBy = createdBy == null ? "" : createdBy;
    }

    public int getVersion() {
        return this.version;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void updateVersion() {
        ++this.version;
        this.updateTime = System.currentTimeMillis();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public CompoundTag write(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("slots", this.stacks.size());
        nbt.putInt("version", this.version);
        nbt.putLong("crTime", this.creationTime);
        nbt.putLong("upTime", this.updateTime);
        nbt.putString("createdBy", this.createdBy);
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            Tag tag = ((ItemStack)this.stacks.get(i)).save(provider, (Tag)itemTag);
            nbtTagList.add((Object)tag);
        }
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putUUID("UUID", this.uuid);
        return nbt;
    }

    public void resize(int size, String createdBy) {
        NonNullList<ItemStack> oldList = this.stacks;
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < Math.min(oldList.size(), size); ++i) {
            this.stacks.set(i, (Object)((ItemStack)oldList.get(i)));
        }
        this.updateTime = System.currentTimeMillis();
        if (createdBy != null && !createdBy.isEmpty()) {
            this.createdBy = createdBy;
        }
    }
}

