/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage.sorters;

import java.util.Comparator;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.storage.sorters.ItemSorter;
import mcjty.rftoolsstorage.storage.sorters.NameItemSorter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class ModItemSorter
implements ItemSorter {
    @Override
    public String getName() {
        return "mod";
    }

    @Override
    public String getTooltip() {
        return "Sort on mod";
    }

    @Override
    public int getU() {
        return 240;
    }

    @Override
    public int getV() {
        return 0;
    }

    @Override
    public Comparator<Pair<ItemStack, Integer>> getComparator() {
        return ModItemSorter::compareMod;
    }

    @Override
    public boolean isSameGroup(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        String name1 = ModItemSorter.getMod(o1);
        String name2 = ModItemSorter.getMod(o2);
        return name1.equals(name2);
    }

    public static int compareMod(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        String name2;
        String name1 = ModItemSorter.getMod(o1);
        if (name1.equals(name2 = ModItemSorter.getMod(o2))) {
            return NameItemSorter.compareNames(o1, o2);
        }
        return name1.compareTo(name2);
    }

    public static String getModidForBlock(Block block) {
        ResourceLocation nameForObject = Tools.getId((Block)block);
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.getNamespace();
    }

    public static String getModidForItem(Item item) {
        ResourceLocation nameForObject = Tools.getId((Item)item);
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.getNamespace();
    }

    private static String getMod(Pair<ItemStack, Integer> object) {
        ItemStack stack = (ItemStack)object.getKey();
        return ModItemSorter.getMod(stack);
    }

    public static String getMod(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            return ModItemSorter.getModidForBlock(block);
        }
        return ModItemSorter.getModidForItem(item);
    }

    @Override
    public String getGroupName(Pair<ItemStack, Integer> object) {
        return ModItemSorter.getMod(object);
    }
}

