/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import quek.undergarden.entity.Boomgourd;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class BoomgourdBlock
extends TntBlock {
    public BoomgourdBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity entity) {
        if (!level.isClientSide()) {
            Boomgourd boomgourd = new Boomgourd(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, entity);
            level.addFreshEntity((Entity)boomgourd);
            level.playSound(null, boomgourd.getX(), boomgourd.getY(), boomgourd.getZ(), (SoundEvent)UGSoundEvents.BOOMGOURD_PRIMED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)entity, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide()) {
            Boomgourd boomgourd = new Boomgourd(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity());
            int fuse = boomgourd.getFuse();
            boomgourd.setFuse((short)(level.getRandom().nextInt(fuse / 4) + fuse / 8));
            level.addFreshEntity((Entity)boomgourd);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE) || stack.is((Item)UGItems.DITCHBULB_PASTE.get()))) {
            return super.useItemOn(stack, state, level, pos, player, hand, result);
        }
        this.onCaughtFire(state, level, pos, result.getDirection(), (LivingEntity)player);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        Item item = stack.getItem();
        if (!player.isCreative()) {
            if (stack.is(Items.FLINT_AND_STEEL)) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            } else {
                stack.shrink(1);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

