/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import quek.undergarden.block.SpreadingSnowyDeepsoilBlock;
import quek.undergarden.registry.UGBlocks;

public class DeepturfBlock
extends SpreadingSnowyDeepsoilBlock
implements BonemealableBlock {
    public DeepturfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.above();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((blockpos1 = blockpos1.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)level, blockpos1)) continue block0;
            }
            BlockState blockstate2 = level.getBlockState(blockpos1);
            if (blockstate2.is(DeepturfBlock.deepturfOrShimmerweed(random).getBlock()) && random.nextInt(10) == 0) {
                ((BonemealableBlock)DeepturfBlock.deepturfOrShimmerweed(random).getBlock()).performBonemeal(level, random, blockpos1, blockstate2);
            }
            if (!blockstate2.isAir() || !DeepturfBlock.deepturfOrShimmerweed(random).canSurvive((LevelReader)level, blockpos1)) continue;
            level.setBlock(blockpos1, DeepturfBlock.deepturfOrShimmerweed(random), 3);
        }
    }

    private static BlockState deepturfOrShimmerweed(RandomSource random) {
        if (random.nextInt(10) == 0) {
            return ((Block)UGBlocks.SHIMMERWEED.get()).defaultBlockState();
        }
        return ((Block)UGBlocks.DEEPTURF.get()).defaultBlockState();
    }
}

