/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.block.DenizenTotemBlock;
import quek.undergarden.client.particle.TotemBeamParticle;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGEffects;

public class DenizenTotemBlockEntity
extends BlockEntity {
    private int ticker;

    public DenizenTotemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)UGBlockEntities.DENIZEN_TOTEM.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DenizenTotemBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ++blockEntity.ticker;
            if (blockEntity.ticker % 20 == 0) {
                List entityList = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(5.0));
                if (!entityList.isEmpty()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DenizenTotemBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
                    entityList.stream().filter(entity -> !entity.hasEffect(UGEffects.PURITY)).forEach(entity -> {
                        entity.addEffect(new MobEffectInstance(UGEffects.PURITY, 160 + level.getRandom().nextInt(5) * 20, 0, true, true));
                        blockEntity.drawParticlesTo(sl, pos.getCenter(), (Entity)entity);
                    });
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DenizenTotemBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    private void drawParticlesTo(ServerLevel level, Vec3 totemPos, Entity highlight) {
        RandomSource random = level.getRandom();
        for (int i = 0; i < 20; ++i) {
            AABB aabb = highlight.getBoundingBox();
            Vec3 toEntity = aabb.getMinPosition().add(random.nextDouble() * aabb.getXsize(), random.nextDouble() * aabb.getYsize(), random.nextDouble() * aabb.getZsize());
            level.sendParticles((ParticleOptions)new TotemBeamParticle.Options(toEntity, random.nextInt(40) + 10), totemPos.x, totemPos.y, totemPos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

