/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.block.portal.UndergardenPortalBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGTags;

public class UndergardenPortalShape {
    private static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 2;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBehaviour.StatePredicate FRAME = (state, getter, pos) -> state.is(UGTags.Blocks.PORTAL_FRAME_BLOCKS);
    private final LevelAccessor level;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int numPortalBlocks;
    private BlockPos bottomLeft;
    private int height;
    private final int width;

    public UndergardenPortalShape(LevelAccessor level, BlockPos bottomLeftPos, Direction.Axis axis) {
        this.level = level;
        this.axis = axis;
        this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(bottomLeftPos);
        if (this.bottomLeft == null) {
            this.bottomLeft = bottomLeftPos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockPos pos) {
        int i = Math.max(this.level.getMinBuildHeight(), pos.getY() - 21);
        while (pos.getY() > i && UndergardenPortalShape.isEmpty(this.level.getBlockState(pos.below()))) {
            pos = pos.below();
        }
        Direction direction = this.rightDir.getOpposite();
        int j = this.getDistanceUntilEdgeAboveFrame(pos, direction) - 1;
        return j < 0 ? null : pos.relative(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 1 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            mutablePos.set((Vec3i)pos).move(direction, i);
            BlockState blockstate = this.level.getBlockState((BlockPos)mutablePos);
            if (!UndergardenPortalShape.isEmpty(blockstate)) {
                if (!FRAME.test(blockstate, (BlockGetter)this.level, (BlockPos)mutablePos)) break;
                return i;
            }
            BlockState blockstate1 = this.level.getBlockState((BlockPos)mutablePos.move(Direction.DOWN));
            if (!FRAME.test(blockstate1, (BlockGetter)this.level, (BlockPos)mutablePos)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int i = this.getDistanceUntilTop(mutablePos);
        return i >= 2 && i <= 21 && this.hasTopFrame(mutablePos, i) ? i : 0;
    }

    private boolean hasTopFrame(BlockPos.MutableBlockPos pos, int height) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.MutableBlockPos mutablePos = pos.set((Vec3i)this.bottomLeft).move(Direction.UP, height).move(this.rightDir, i);
            if (FRAME.test(this.level.getBlockState((BlockPos)mutablePos), (BlockGetter)this.level, (BlockPos)mutablePos)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPos.MutableBlockPos pos) {
        for (int i = 0; i < 21; ++i) {
            pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, -1);
            if (!FRAME.test(this.level.getBlockState((BlockPos)pos), (BlockGetter)this.level, (BlockPos)pos)) {
                return i;
            }
            pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, this.width);
            if (!FRAME.test(this.level.getBlockState((BlockPos)pos), (BlockGetter)this.level, (BlockPos)pos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, j);
                BlockState blockstate = this.level.getBlockState((BlockPos)pos);
                if (!UndergardenPortalShape.isEmpty(blockstate)) {
                    return i;
                }
                if (!blockstate.is((Block)UGBlocks.UNDERGARDEN_PORTAL.get())) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean isEmpty(BlockState state) {
        return state.isAir() || state.is((Block)UGBlocks.UNDERGARDEN_PORTAL.get());
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 2 && this.height <= 21;
    }

    public int getPortalBlocks() {
        return this.numPortalBlocks;
    }

    public void createPortalBlocks() {
        BlockState blockstate = (BlockState)((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).defaultBlockState().setValue(UndergardenPortalBlock.AXIS, (Comparable)this.axis);
        BlockPos.betweenClosed((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(pos -> this.level.setBlock(pos, blockstate, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }
}

