/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.Minion;

public class MinionModel<T extends Minion>
extends ListModel<T> {
    private final ModelPart shell;
    private final ModelPart body;
    private final ModelPart backRightLeg;
    private final ModelPart backLeftLeg;
    private final ModelPart frontLeftLeg;
    private final ModelPart frontRightLeg;

    public MinionModel(ModelPart root) {
        this.shell = root.getChild("shell");
        this.body = root.getChild("body");
        this.backRightLeg = this.body.getChild("backRightLeg");
        this.backLeftLeg = this.body.getChild("backLeftLeg");
        this.frontLeftLeg = this.body.getChild("frontLeftLeg");
        this.frontRightLeg = this.body.getChild("frontRightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition shell = partdefinition.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -14.0f, -8.0f, 12.0f, 17.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(40, 32).addBox(-5.0f, -13.0f, -7.0f, 10.0f, 13.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)-3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 13.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(27, 53).addBox(-3.0f, -6.0f, -16.0f, 6.0f, 6.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)11.0f, (float)-3.0f));
        PartDefinition backRightLeg = body.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(39, 0).addBox(-5.0f, 0.0f, 0.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)6.0f, (float)7.0f));
        PartDefinition backLeftLeg = body.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(52, 53).addBox(0.0f, 0.0f, 0.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)6.0f, (float)7.0f));
        PartDefinition frontLeftLeg = body.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(54, 7).addBox(0.0f, 0.0f, -5.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)6.0f, (float)-1.0f));
        PartDefinition frontRightLeg = body.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(54, 19).addBox(-5.0f, 0.0f, -5.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)6.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frontLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.frontRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.backLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.backRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.shell, (Object)this.body);
    }
}

