/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster.boss;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import quek.undergarden.registry.UGSoundEvents;

public class ForgottenGuardian
extends Monster {
    private int attackTimer;

    public ForgottenGuardian(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 30;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.ARMOR, 10.0).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_STEP.get(), 0.5f, 1.0f);
    }

    public boolean canChangeDimensions(Level p_352904_, Level p_352909_) {
        return false;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else {
            this.noActionTime = 0;
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.isAggressive() && this.horizontalCollision && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            AABB axisalignedbb = this.getBoundingBox().inflate(0.2, 0.0, 0.2);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)axisalignedbb.minX), (int)Mth.floor((double)axisalignedbb.minY), (int)Mth.floor((double)axisalignedbb.minZ), (int)Mth.floor((double)axisalignedbb.maxX), (int)Mth.floor((double)axisalignedbb.maxY), (int)Mth.floor((double)axisalignedbb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.is(BlockTags.WITHER_IMMUNE)) continue;
                this.level().destroyBlock(blockpos, false, (Entity)this);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        this.attackTimer = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_ATTACK.get(), 1.0f, 1.0f);
        return super.doHurtTarget(entity);
    }

    protected void blockedByShield(LivingEntity entity) {
        double x = entity.getX() - this.getX();
        double z = entity.getZ() - this.getZ();
        double modifier = Math.max(x * x + z * z, 0.001);
        entity.push(x / modifier * 2.0, (double)0.2f, z / modifier * 2.0);
        entity.hurtMarked = true;
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof Projectile) {
            this.playSound((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_DEFLECT.get(), 1.0f, 1.0f);
            return false;
        }
        return super.hurt(source, amount);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected PathNavigation createNavigation(Level level) {
        return new Navigator((Mob)this, level);
    }

    public boolean canBeLeashed() {
        return false;
    }

    static class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob entity, Level level) {
            super(entity, level);
        }

        protected PathFinder createPathFinder(int range) {
            this.nodeEvaluator = new Evaluator();
            return new PathFinder(this.nodeEvaluator, range);
        }
    }

    static class Evaluator
    extends WalkNodeEvaluator {
        private Evaluator() {
        }

        public Set<PathType> getPathTypeWithinMobBB(PathfindingContext context, int width, int height, int depth) {
            return Set.of(PathType.WALKABLE);
        }
    }
}

