/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import quek.undergarden.recipe.InfusingBookCategory;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGRecipeSerializers;

public record InfuserConversionRecipe(InfusingBookCategory category, Ingredient ingredient, ItemStack result, int infusingTime, float experience, InfusingRecipe.SlotType slotType) implements InfusingRecipe
{
    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient().test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.result().copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)UGRecipeSerializers.INFUSER_CONVERSION.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient()});
    }

    @Override
    public InfusingRecipe.SlotType getRecipeSlotType() {
        return this.slotType();
    }

    public static class Serializer
    implements RecipeSerializer<InfuserConversionRecipe> {
        private static final MapCodec<InfuserConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)InfusingBookCategory.CODEC.fieldOf("category").orElse((Object)InfusingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("infusing_time").orElse((Object)200).forGetter(recipe -> recipe.infusingTime), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)InfusingRecipe.SlotType.CODEC.fieldOf("slot_type").forGetter(recipe -> recipe.slotType)).apply((Applicative)instance, InfuserConversionRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, InfuserConversionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec(InfusingBookCategory.CODEC), InfuserConversionRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, InfuserConversionRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, InfuserConversionRecipe::result, (StreamCodec)ByteBufCodecs.INT, InfuserConversionRecipe::infusingTime, (StreamCodec)ByteBufCodecs.FLOAT, InfuserConversionRecipe::experience, (StreamCodec)ByteBufCodecs.fromCodec(InfusingRecipe.SlotType.CODEC), InfuserConversionRecipe::slotType, InfuserConversionRecipe::new);

        public MapCodec<InfuserConversionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfuserConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

