/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public enum InputSide {
    A(PlateBlockStateProperties.INPUT_A, 1),
    B(PlateBlockStateProperties.INPUT_B, 2),
    C(PlateBlockStateProperties.INPUT_C, 3);

    public final BooleanProperty property;
    public final int rotationsFromOutput;

    private InputSide(BooleanProperty property, int rotationsFromOutput) {
        this.property = property;
        this.rotationsFromOutput = rotationsFromOutput;
    }

    public boolean isBlockReceivingPower(Level world, BlockState state, BlockPos pos) {
        int baseRotation;
        if (!(state.hasProperty((Property)this.property) && state.hasProperty((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION) && state.hasProperty((Property)PlateBlockStateProperties.ROTATION))) {
            return false;
        }
        Direction attachmentDirection = (Direction)state.getValue((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
        Direction inputDirection = BlockStateUtil.getInputDirection(attachmentDirection, baseRotation = ((Integer)state.getValue((Property)PlateBlockStateProperties.ROTATION)).intValue(), this.rotationsFromOutput);
        BlockPos inputPos = pos.relative(inputDirection);
        int power = world.getSignal(inputPos, inputDirection);
        if (power > 0) {
            return true;
        }
        BlockState inputState = world.getBlockState(inputPos);
        return inputState.getBlock() == Blocks.REDSTONE_WIRE && (Integer)inputState.getValue((Property)RedStoneWireBlock.POWER) > 0;
    }
}

