/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import com.google.common.collect.ImmutableSet;
import com.mojang.math.OctahedralGroup;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import commoble.morered.MoreRed;
import commoble.morered.util.EightGroup;
import commoble.morered.util.NestedBoundingBox;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class WirePostBlockEntity
extends BlockEntity {
    public static final String CONNECTIONS = "connections";
    public static final AABB EMPTY_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private Map<BlockPos, NestedBoundingBox> remoteConnections = new HashMap<BlockPos, NestedBoundingBox>();
    private AABB renderAABB = EMPTY_AABB;
    public static final Codec<List<BlockPos>> BLOCKPOS_LISTER = BlockPos.CODEC.listOf();

    public WirePostBlockEntity(BlockEntityType<? extends WirePostBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public WirePostBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoreRed.get().redwirePostBeType.get(), pos, state);
    }

    public static boolean addConnection(LevelAccessor world, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = world.getBlockEntity(posA);
        if (blockEntity instanceof WirePostBlockEntity) {
            WirePostBlockEntity postA = (WirePostBlockEntity)blockEntity;
            blockEntity = world.getBlockEntity(posB);
            if (blockEntity instanceof WirePostBlockEntity) {
                WirePostBlockEntity postB = (WirePostBlockEntity)blockEntity;
                return WirePostBlockEntity.addConnection(world, postA, postB);
            }
        }
        return false;
    }

    public static boolean addConnection(LevelAccessor world, @Nonnull WirePostBlockEntity postA, @Nonnull WirePostBlockEntity postB) {
        postA.addConnection(postB.worldPosition);
        postB.addConnection(postA.worldPosition);
        return true;
    }

    public void setConnectionsRaw(Map<BlockPos, NestedBoundingBox> connections) {
        this.remoteConnections = connections;
    }

    public Set<BlockPos> getRemoteConnections() {
        return ImmutableSet.copyOf(this.remoteConnections.keySet());
    }

    public Map<BlockPos, NestedBoundingBox> getRemoteConnectionBoxes() {
        return this.remoteConnections;
    }

    public boolean hasRemoteConnection(BlockPos otherPos) {
        return this.remoteConnections.keySet().contains(otherPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean arePostsConnected(LevelAccessor level, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = level.getBlockEntity(posA);
        if (!(blockEntity instanceof WirePostBlockEntity)) return false;
        WirePostBlockEntity postA = (WirePostBlockEntity)blockEntity;
        blockEntity = level.getBlockEntity(posB);
        if (!(blockEntity instanceof WirePostBlockEntity)) return false;
        WirePostBlockEntity postB = (WirePostBlockEntity)blockEntity;
        if (!postA.hasRemoteConnection(posB)) return false;
        if (!postB.hasRemoteConnection(posA)) return false;
        return true;
    }

    public void clearRemoteConnections() {
        for (BlockPos otherPos : this.remoteConnections.keySet()) {
            BlockEntity blockEntity = this.level.getBlockEntity(otherPos);
            if (!(blockEntity instanceof WirePostBlockEntity)) continue;
            WirePostBlockEntity otherPost = (WirePostBlockEntity)blockEntity;
            otherPost.removeConnection(this.worldPosition);
        }
        this.remoteConnections = new HashMap<BlockPos, NestedBoundingBox>();
        this.onCommonDataUpdated();
    }

    public static void removeConnection(LevelAccessor world, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = world.getBlockEntity(posA);
        if (blockEntity instanceof WirePostBlockEntity) {
            WirePostBlockEntity postA = (WirePostBlockEntity)blockEntity;
            postA.removeConnection(posB);
        }
        if ((blockEntity = world.getBlockEntity(posB)) instanceof WirePostBlockEntity) {
            WirePostBlockEntity postB = (WirePostBlockEntity)blockEntity;
            postB.removeConnection(posA);
        }
    }

    private void addConnection(BlockPos otherPos) {
        this.remoteConnections.put(otherPos.immutable(), this.getNestedBoundingBoxForConnectedPos(otherPos));
        this.level.neighborChanged(this.worldPosition, this.getBlockState().getBlock(), otherPos);
        this.onCommonDataUpdated();
    }

    private void removeConnection(BlockPos otherPos) {
        this.remoteConnections.remove(otherPos);
        this.level.neighborChanged(this.worldPosition, this.getBlockState().getBlock(), otherPos);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            int otherY;
            ServerLevel serverLevel = (ServerLevel)level;
            int thisY = this.worldPosition.getY();
            if (thisY < (otherY = otherPos.getY()) || thisY == otherY && this.worldPosition.hashCode() < otherPos.hashCode()) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new WireBreakPacket(Vec3.atCenterOf((Vec3i)this.worldPosition), Vec3.atCenterOf((Vec3i)otherPos)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.onCommonDataUpdated();
    }

    public void notifyConnections() {
        this.getRemoteConnections().forEach(connectionPos -> this.level.neighborChanged(connectionPos, this.getBlockState().getBlock(), this.worldPosition));
    }

    public AABB getRenderBoundingBox() {
        return this.renderAABB;
    }

    public static AABB getAABBContainingAllBlockPos(BlockPos startPos, Set<BlockPos> theRest) {
        return theRest.stream().map(AABB::new).reduce(EMPTY_AABB, AABB::minmax, AABB::minmax).minmax(new AABB(startPos));
    }

    public void onCommonDataUpdated() {
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.readCommonData(compound);
    }

    protected void readCommonData(CompoundTag compound) {
        if (compound.contains(CONNECTIONS)) {
            List normalizedPositions = BLOCKPOS_LISTER.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get(CONNECTIONS)).result().orElse(List.of());
            ArrayList<BlockPos> absolutePositions = new ArrayList<BlockPos>();
            for (BlockPos normalPos : normalizedPositions) {
                absolutePositions.add(this.denormalizePos(normalPos));
            }
            HashMap<BlockPos, NestedBoundingBox> newMap = new HashMap<BlockPos, NestedBoundingBox>();
            absolutePositions.forEach(otherPos -> newMap.put((BlockPos)otherPos, this.getNestedBoundingBoxForConnectedPos((BlockPos)otherPos)));
            this.remoteConnections = newMap;
        }
        this.renderAABB = WirePostBlockEntity.getAABBContainingAllBlockPos(this.worldPosition, this.remoteConnections.keySet());
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        ArrayList<BlockPos> normalizedPositions = new ArrayList<BlockPos>();
        for (BlockPos absolutePos : this.remoteConnections.keySet()) {
            normalizedPositions.add(this.normalizePos(absolutePos));
        }
        BLOCKPOS_LISTER.encodeStart((DynamicOps)NbtOps.INSTANCE, normalizedPositions).result().ifPresent(tag -> compound.put(CONNECTIONS, tag));
    }

    public BlockPos normalizePos(BlockPos absolutePos) {
        BlockPos relativePos = absolutePos.subtract((Vec3i)this.getBlockPos());
        OctahedralGroup normalizer = ((OctahedralGroup)this.getBlockState().getValue((Property)WirePostBlock.TRANSFORM)).inverse();
        BlockPos normalizedPos = EightGroup.transform(relativePos, normalizer);
        return normalizedPos;
    }

    public BlockPos denormalizePos(BlockPos normalPos) {
        OctahedralGroup denormalizer = (OctahedralGroup)this.getBlockState().getValue((Property)WirePostBlock.TRANSFORM);
        BlockPos relativePos = EightGroup.transform(normalPos, denormalizer);
        BlockPos absolutePos = relativePos.offset((Vec3i)this.getBlockPos());
        return absolutePos;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compound = super.getUpdateTag(registries);
        this.saveAdditional(compound, registries);
        return compound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public NestedBoundingBox getNestedBoundingBoxForConnectedPos(BlockPos otherPos) {
        Vec3 thisVec = Vec3.atCenterOf((Vec3i)this.worldPosition);
        Vec3 otherVec = Vec3.atCenterOf((Vec3i)otherPos);
        boolean otherHigher = otherVec.y > thisVec.y;
        Vec3 higherVec = otherHigher ? otherVec : thisVec;
        Vec3 lowerVec = otherHigher ? thisVec : otherVec;
        Vec3[] points = SlackInterpolator.getInterpolatedPoints(lowerVec, higherVec);
        int segmentCount = points.length - 1;
        AABB[] boxes = new AABB[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            boxes[i] = new AABB(points[i], points[i + 1]);
        }
        return NestedBoundingBox.fromAABBs(boxes);
    }
}

