/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.MoreRed;
import commoble.morered.ServerConfig;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class WireSpoolItem
extends Item {
    protected final TagKey<Block> postBlockTag;

    public WireSpoolItem(Item.Properties properties, TagKey<Block> postBlockTag) {
        super(properties);
        this.postBlockTag = postBlockTag;
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionResult;
        BlockEntity blockEntity;
        BlockPos pos;
        Level level = context.getLevel();
        if (level.getBlockState(pos = context.getClickedPos()).is(this.postBlockTag) && (blockEntity = level.getBlockEntity(pos)) instanceof WirePostBlockEntity) {
            WirePostBlockEntity post = (WirePostBlockEntity)blockEntity;
            interactionResult = this.onUseOnPost(level, pos, post, context.getItemInHand(), context.getPlayer(), context.getHand());
        } else {
            interactionResult = super.useOn(context);
        }
        return interactionResult;
    }

    private InteractionResult onUseOnPost(Level level, BlockPos pos, @Nonnull WirePostBlockEntity post, ItemStack stack, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DataComponentType spooledPost = (DataComponentType)MoreRed.get().spooledPostComponent.get();
                BlockPos lastPos = (BlockPos)stack.get(spooledPost);
                if (lastPos == null) {
                    stack.set((DataComponentType)MoreRed.get().spooledPostComponent.get(), (Object)pos);
                } else if (lastPos.equals((Object)pos)) {
                    stack.remove(spooledPost);
                } else if (post.hasRemoteConnection(lastPos)) {
                    WirePostBlockEntity.removeConnection((LevelAccessor)level, pos, lastPos);
                    stack.remove(spooledPost);
                } else {
                    BlockPos upperPos;
                    boolean lastPosIsHigher = pos.getY() < lastPos.getY();
                    BlockPos lowerPos = lastPosIsHigher ? pos : lastPos;
                    Vec3 hit = SlackInterpolator.getWireRaytraceHit(lowerPos, upperPos = lastPosIsHigher ? lastPos : pos, (BlockGetter)level);
                    if (hit != null) {
                        stack.remove(spooledPost);
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new WireBreakPacket(Vec3.atCenterOf((Vec3i)lowerPos), Vec3.atCenterOf((Vec3i)upperPos)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        serverLevel.sendParticles(serverPlayer, (ParticleOptions)DustParticleOptions.REDSTONE, false, hit.x, hit.y, hit.z, 5, 0.05, 0.05, 0.05, 0.0);
                        serverPlayer.playNotifySound(SoundEvents.WANDERING_TRADER_HURT, SoundSource.BLOCKS, 0.5f, 2.0f);
                    } else if (pos.closerThan((Vec3i)lastPos, ((Double)ServerConfig.INSTANCE.maxWirePostConnectionRange().get()).doubleValue())) {
                        stack.remove(spooledPost);
                        BlockEntity blockEntity = level.getBlockEntity(lastPos);
                        if (blockEntity instanceof WirePostBlockEntity) {
                            WirePostBlockEntity lastPost = (WirePostBlockEntity)blockEntity;
                            WirePostBlockEntity.addConnection((LevelAccessor)level, post, lastPost);
                        }
                        stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    } else {
                        stack.set(spooledPost, (Object)pos);
                    }
                }
                level.playSound(null, pos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.2f + level.random.nextFloat() * 0.1f, 0.7f + level.random.nextFloat() * 0.1f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityIn;
            DataComponentType spooledPost = (DataComponentType)MoreRed.get().spooledPostComponent.get();
            BlockPos postPos = (BlockPos)stack.get(spooledPost);
            if (postPos != null && this.shouldRemoveConnection(postPos, worldIn, entityIn)) {
                stack.remove(spooledPost);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new WireBreakPacket(Vec3.atCenterOf((Vec3i)postPos), entityIn.getEyePosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public boolean shouldRemoveConnection(BlockPos connectionPos, Level world, Entity holder) {
        double maxDistance = (Double)ServerConfig.INSTANCE.maxWirePostConnectionRange().get();
        if (holder.position().distanceToSqr(Vec3.atCenterOf((Vec3i)connectionPos)) > maxDistance * maxDistance) {
            return true;
        }
        return !world.getBlockState(connectionPos).is(this.postBlockTag);
    }
}

