/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.entity.potion.FertilePotion;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.reference.Config;

public class FertilePotionItem
extends ItemBase
implements ProjectileItem {
    public FertilePotionItem() {
        super(new Item.Properties(), (Supplier<Boolean>)Config.COMMON.disable.disablePotions);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        level.playSound(null, player.blockPosition(), SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        FertilePotion fertilePotion = new FertilePotion(level, player);
        fertilePotion.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.7f, 1.0f);
        level.addFreshEntity((Entity)fertilePotion);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        return new FertilePotion(level, position);
    }
}

