/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ImportMode;
import com.ultramega.cabletiers.common.mixin.InvokerAbstractTaskPattern;
import com.ultramega.cabletiers.common.mixin.InvokerTaskImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ExtendedPatternProviderNetworkNode
extends PatternProviderNetworkNode {
    private final Filter emptyFilter = new Filter();
    private final Map<Integer, List<ResourceAmount>> patternOutputs = new HashMap<Integer, List<ResourceAmount>>();
    private final Filter patternOutputFilter = new Filter();
    private final List<ResourceKey> requestedResources = new ArrayList<ResourceKey>();
    private final Filter requestedResourceFilter = new Filter();
    private final Map<TaskId, Set<ResourceKey>> requestedResourcesDeep = new HashMap<TaskId, Set<ResourceKey>>();
    private final Filter requestedResourceFilterDeep = new Filter();
    private final Actor actor = new NetworkNodeActor((NetworkNode)this);
    @Nullable
    private Supplier<ImportMode> importMode;
    @Nullable
    private ImporterTransferStrategy transferStrategy;

    public ExtendedPatternProviderNetworkNode(long energyUsage, int patterns) {
        super(energyUsage, patterns);
        this.patternOutputFilter.setMode(FilterMode.ALLOW);
        this.requestedResourceFilter.setMode(FilterMode.ALLOW);
        this.requestedResourceFilterDeep.setMode(FilterMode.ALLOW);
    }

    public void doWork() {
        Filter filter;
        ImportMode mode;
        super.doWork();
        if (this.network == null || !this.isActive() || this.transferStrategy == null) {
            return;
        }
        ImportMode importMode = mode = this.importMode != null ? this.importMode.get() : null;
        if (mode == null || mode == ImportMode.DONT_IMPORT) {
            return;
        }
        switch (mode) {
            case IMPORT_EVERYTHING: {
                Filter filter2 = this.emptyFilter;
                break;
            }
            case IMPORT_PATTERN_OUTPUTS: {
                Filter filter2 = this.patternOutputFilter;
                break;
            }
            case IMPORT_REQUESTED_RESOURCES: {
                Filter filter2 = this.requestedResourceFilter;
                break;
            }
            case IMPORT_REQUESTED_RESOURCES_DEEP: {
                Filter filter2 = this.requestedResourceFilterDeep;
                break;
            }
            default: {
                Filter filter2 = filter = null;
            }
        }
        if (filter != null) {
            if (this.removeCompletedPatternsFromRequestedResourcesDeep()) {
                return;
            }
            this.transferStrategy.transfer(filter, this.actor, this.network);
        }
    }

    public void addTask(Task task) {
        super.addTask(task);
        this.requestedResources.add(task.getResource());
        this.requestedResourceFilter.setFilters(new HashSet<ResourceKey>(this.requestedResources));
        Set<ResourceKey> resources = this.collectAllPatternOutputs(task);
        this.requestedResourcesDeep.put(task.getId(), resources);
        this.updateDeepFilter();
    }

    public void removeRequestedResourceFilter(Task task) {
        this.requestedResources.remove(task.getResource());
        this.requestedResourceFilter.setFilters(new HashSet<ResourceKey>(this.requestedResources));
        this.requestedResourcesDeep.remove(task.getId());
        this.updateDeepFilter();
    }

    private Set<ResourceKey> collectAllPatternOutputs(Task task) {
        if (task instanceof InvokerTaskImpl) {
            InvokerTaskImpl taskImpl = (InvokerTaskImpl)task;
            HashSet<ResourceKey> resources = new HashSet<ResourceKey>();
            taskImpl.cabletiers$getPatterns().keySet().forEach(pattern -> pattern.layout().outputs().forEach(resource -> resources.add(resource.resource())));
            return resources;
        }
        return Set.of();
    }

    private void updateDeepFilter() {
        Set mergedResources = this.requestedResourcesDeep.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        this.requestedResourceFilterDeep.setFilters(mergedResources);
    }

    private boolean removeCompletedPatternsFromRequestedResourcesDeep() {
        boolean changed = false;
        for (Task task : this.getTasks()) {
            if (!(task instanceof InvokerTaskImpl)) continue;
            InvokerTaskImpl taskImpl = (InvokerTaskImpl)task;
            TaskId taskId = task.getId();
            Set<ResourceKey> trackedResources = this.requestedResourcesDeep.get(taskId);
            if (trackedResources == null || trackedResources.isEmpty()) continue;
            HashSet<ResourceKey> toRemove = new HashSet<ResourceKey>();
            for (InvokerAbstractTaskPattern taskPattern : taskImpl.cabletiers$getCompletedPatterns()) {
                for (ResourceAmount output : taskPattern.cabletiers$getPattern().layout().outputs()) {
                    ResourceKey resource = output.resource();
                    if (!trackedResources.contains(resource)) continue;
                    toRemove.add(resource);
                }
            }
            if (toRemove.isEmpty()) continue;
            trackedResources.removeAll(toRemove);
            changed = true;
            if (!trackedResources.isEmpty()) continue;
            this.requestedResourcesDeep.remove(taskId);
        }
        if (changed) {
            this.updateDeepFilter();
        }
        return changed;
    }

    public void setTransferStrategy(ImporterTransferStrategy transferStrategy) {
        this.transferStrategy = transferStrategy;
    }

    public void updatePatternOutputFilter(int slot, @Nullable Pattern pattern) {
        this.patternOutputs.put(slot, pattern != null ? pattern.layout().outputs() : null);
        Set filters = this.patternOutputs.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).map(ResourceAmount::resource).collect(Collectors.toSet());
        this.patternOutputFilter.setFilters(filters);
    }

    public void setImportMode(Supplier<ImportMode> importMode) {
        this.importMode = importMode;
    }
}

