/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.capability;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ImprovedInvWrapper
extends InvWrapper {
    public ImprovedInvWrapper(Container inv) {
        super(inv);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.max(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.getInv().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.max(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInv().setItem(slot, copy);
                    this.getInv().setChanged();
                }
                return ItemStack.EMPTY;
            }
            ItemStack copyStack = stack.copy();
            if (!simulate) {
                ItemStack copy = copyStack.split(m);
                copy.grow(stackInSlot.getCount());
                this.getInv().setItem(slot, copy);
                this.getInv().setChanged();
                return copyStack;
            }
            copyStack.shrink(m);
            return copyStack;
        }
        if (!this.getInv().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.max(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            ItemStack copyStack = stack.copy();
            if (!simulate) {
                this.getInv().setItem(slot, copyStack.split(m));
                this.getInv().setChanged();
                return copyStack;
            }
            copyStack.shrink(m);
            return copyStack;
        }
        if (!simulate) {
            this.getInv().setItem(slot, stack);
            this.getInv().setChanged();
        }
        return ItemStack.EMPTY;
    }
}

