/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen;

import com.refinedmods.refinedstorage.common.constructordestructor.AbstractConstructorDestructorBlock;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.iface.TieredInterfaceBlock;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateProviderImpl
extends BlockStateProvider {
    protected static final String BLOCK_PREFIX = "block";
    private final ExistingFileHelper existingFileHelper;

    public BlockStateProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "cabletiers", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        for (CableTiers tier : CableTiers.values()) {
            this.registerCableLike(Blocks.INSTANCE.getTieredImporters(tier), tier.getLowercaseName() + "_importer");
            this.registerCableLike(Blocks.INSTANCE.getTieredExporters(tier), tier.getLowercaseName() + "_exporter");
            this.registerConstructorDestructor(Blocks.INSTANCE.getTieredDestructors(tier), tier.getLowercaseName() + "_destructor");
            this.registerConstructorDestructor(Blocks.INSTANCE.getTieredConstructors(tier), tier.getLowercaseName() + "_constructor");
            this.registerDiskInterfaces(tier, tier.getLowercaseName() + "_disk_interface");
            this.registerAutocrafters(tier, tier.getLowercaseName() + "_autocrafter");
            this.registerInterfaces(tier, tier.getLowercaseName() + "_interface");
        }
    }

    private void registerCableLike(BlockColorMap<?, ?> blockMap, String type) {
        ModelFile model = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + type));
        blockMap.forEach((color, id, block) -> {
            MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
            ConfiguredModel.Builder cablePart = builder.part();
            cablePart.modelFile(this.getCableModel(color)).addModel();
            for (Direction direction : Direction.values()) {
                ConfiguredModel.Builder part = builder.part();
                BlockStateProviderImpl.addDirectionalRotation(direction, (ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)part);
                ((MultiPartBlockStateBuilder.PartBuilder)part.modelFile(model).addModel()).condition((Property)DefaultDirectionType.FACE_CLICKED.getProperty(), (Comparable[])new Direction[]{direction});
            }
        });
    }

    private void registerConstructorDestructor(BlockColorMap<?, ?> blockMap, String type) {
        ModelFile activeModel = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + type + "/active"));
        ModelFile inactiveModel = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + type + "/inactive"));
        blockMap.forEach((color, id, block) -> {
            MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
            ConfiguredModel.Builder cablePart = builder.part();
            cablePart.modelFile(this.getCableModel(color)).addModel();
            for (Direction direction : Direction.values()) {
                ConfiguredModel.Builder part = builder.part();
                BlockStateProviderImpl.addDirectionalRotation(direction, (ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)part);
                ((MultiPartBlockStateBuilder.PartBuilder)part.modelFile(activeModel).addModel()).condition((Property)DefaultDirectionType.FACE_CLICKED.getProperty(), (Comparable[])new Direction[]{direction}).condition((Property)AbstractConstructorDestructorBlock.ACTIVE, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)part.modelFile(inactiveModel).addModel()).condition((Property)DefaultDirectionType.FACE_CLICKED.getProperty(), (Comparable[])new Direction[]{direction}).condition((Property)AbstractConstructorDestructorBlock.ACTIVE, (Comparable[])new Boolean[]{false}).end();
            }
        });
    }

    private void registerDiskInterfaces(CableTiers tier, String name) {
        Blocks.INSTANCE.getTieredDiskInterfaces(tier).forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.addModels(builder.partialState(), ConfiguredModel.builder().modelFile(this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/" + color.getName()))).build());
        });
    }

    private void registerAutocrafters(CableTiers tier, String name) {
        ModelFile inactive = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/inactive"));
        Blocks.INSTANCE.getTieredAutocrafters(tier).forEach((color, id, block) -> {
            ModelFile active = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/" + color.getName()));
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                    model.modelFile(active);
                } else {
                    model.modelFile(inactive);
                }
                Direction direction = (Direction)blockState.getValue((Property)DefaultDirectionType.FACE_CLICKED.getProperty());
                this.addAutocrafterRotation(model, direction);
                return model.build();
            });
        });
    }

    private void registerInterfaces(CableTiers tier, String name) {
        ModelFile active = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/active"));
        ModelFile inactive = this.modelFile(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/inactive"));
        Supplier<TieredInterfaceBlock> block = Blocks.INSTANCE.getTieredInterfaces(tier);
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        builder.forAllStates(blockState -> {
            ConfiguredModel.Builder model = ConfiguredModel.builder();
            if (Boolean.TRUE.equals(blockState.getValue((Property)TieredInterfaceBlock.ACTIVE))) {
                model.modelFile(active);
            } else {
                model.modelFile(inactive);
            }
            return model.build();
        });
    }

    private static void addDirectionalRotation(Direction direction, ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> part) {
        switch (direction) {
            case UP: {
                part.rotationX(270);
                break;
            }
            case SOUTH: {
                part.rotationX(180);
                break;
            }
            case DOWN: {
                part.rotationX(90);
                break;
            }
            case WEST: {
                part.rotationY(270);
                break;
            }
            case EAST: {
                part.rotationY(90);
                break;
            }
        }
    }

    private void addAutocrafterRotation(ConfiguredModel.Builder<?> model, Direction direction) {
        if (direction.getAxis().isHorizontal()) {
            model.rotationX(90);
        } else if (direction == Direction.DOWN) {
            model.rotationX(180);
        }
        model.rotationY(direction.getAxis().isVertical() ? 0 : ((int)direction.toYRot() + 180) % 360);
    }

    private ModelFile getCableModel(DyeColor color) {
        return this.modelFile(IdentifierUtil.createIdentifier((String)("block/cable/" + color.getName())));
    }

    private ModelFile modelFile(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }
}

