/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityFurnaceHeater;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.IPickaxeBreakable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlockFurnaceHeater
extends BlockContainerImpl
implements ICustomBlockState,
IPickaxeBreakable {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.box((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)4.0), Block.box((double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0)};

    public BlockFurnaceHeater() {
        super("furnace_heater", BlockEntityFurnaceHeater.class, BlockBehaviour.Properties.of().strength(3.0f));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        BlockEntity tile = levelIn.getBlockEntity(pos);
        if (tile instanceof BlockEntityFurnaceHeater) {
            BlockEntityFurnaceHeater heater = (BlockEntityFurnaceHeater)tile;
            if (heater.isActive) {
                float z;
                float y;
                float x;
                Direction facing = (Direction)stateIn.getValue((Property)FACING);
                if (facing == Direction.UP) {
                    x = 0.35f + rand.nextFloat() * 0.3f;
                    y = 0.0f;
                    z = 0.35f + rand.nextFloat() * 0.3f;
                } else if (facing == Direction.DOWN) {
                    x = 0.35f + rand.nextFloat() * 0.3f;
                    y = 1.0f;
                    z = 0.35f + rand.nextFloat() * 0.3f;
                } else {
                    x = facing.getStepZ() != 0 ? 0.35f + rand.nextFloat() * 0.3f : (facing.getStepX() < 0 ? 1.0f : 0.0f);
                    y = 0.35f + rand.nextFloat() * 0.3f;
                    z = facing.getStepX() != 0 ? 0.35f + rand.nextFloat() * 0.3f : (facing.getStepZ() < 0 ? 1.0f : 0.0f);
                }
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.getX() + x, (float)pos.getY() + y, (float)pos.getZ() + z, (rand.nextFloat() * 0.016f + 0.01f) * (float)facing.getStepX(), (rand.nextFloat() * 0.016f + 0.01f) * (float)facing.getStepY(), (rand.nextFloat() * 0.016f + 0.01f) * (float)facing.getStepZ(), 16019010, rand.nextFloat() + 0.5f, 55, 0.0f, true, true);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)FACING)).get3DDataValue()];
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.directionalBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

