/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureSearchEntry
extends ObjectSelectionList.Entry<StructureSearchEntry> {
    private final Minecraft mc;
    private final ExplorersCompassScreen parentScreen;
    private final ResourceLocation structureKey;
    private final StructureSearchList structuresList;
    private long lastClickTime;

    public StructureSearchEntry(StructureSearchList structuresList, ResourceLocation structureKey) {
        this.structuresList = structuresList;
        this.structureKey = structureKey;
        this.parentScreen = structuresList.getParentScreen();
        this.mc = Minecraft.getInstance();
    }

    public void render(GuiGraphics guiGraphics, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        guiGraphics.drawString(this.mc.font, (Component)Component.literal((String)StructureUtils.getPrettyStructureName(this.structureKey)), par3 + 1, par2 + 1, 0xFFFFFF);
        Font font = this.mc.font;
        MutableComponent mutableComponent = Component.translatable((String)"string.explorerscompass.source").append((Component)Component.literal((String)(": " + StructureUtils.getPrettyStructureSource(this.structureKey))));
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font, (Component)mutableComponent, par3 + 1, par2 + 9 + 3, 0x808080);
        Font font2 = this.mc.font;
        MutableComponent mutableComponent2 = Component.translatable((String)"string.explorerscompass.group").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)StructureUtils.getPrettyStructureName(ExplorersCompass.structureKeysToTypeKeys.get(this.structureKey))));
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font2, (Component)mutableComponent2, par3 + 1, par2 + 9 + 14, 0x808080);
        Font font3 = this.mc.font;
        MutableComponent mutableComponent3 = Component.translatable((String)"string.explorerscompass.dimension").append((Component)Component.literal((String)(": " + StructureUtils.dimensionKeysToString(ExplorersCompass.dimensionKeysForAllowedStructureKeys.get((Object)this.structureKey)))));
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font3, (Component)mutableComponent3, par3 + 1, par2 + 9 + 25, 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.structuresList.selectStructure(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.searchForStructure();
                return true;
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }
        return false;
    }

    public Component getNarration() {
        return Component.literal((String)StructureUtils.getPrettyStructureName(this.structureKey));
    }

    public void searchForStructure() {
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.parentScreen.searchForStructure(this.structureKey);
    }

    public void searchForGroup() {
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.parentScreen.searchForGroup(ExplorersCompass.structureKeysToTypeKeys.get(this.structureKey));
    }
}

