/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.client.Point;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.IOptionalSlot;
import appeng.menu.slot.OutputSlot;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.api.IPage;
import com.glodblock.github.extendedae.client.ExSemantics;
import com.glodblock.github.extendedae.common.tileentities.TileExMolecularAssembler;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerExMolecularAssembler
extends UpgradeableMenu<TileExMolecularAssembler>
implements IProgressProvider,
IPage,
IActionHolder {
    public static final MenuType<ContainerExMolecularAssembler> TYPE = MenuTypeBuilder.create(ContainerExMolecularAssembler::new, TileExMolecularAssembler.class).buildUnregistered(ExtendedAE.id("ex_molecular_assembler"));
    private static final int MAX_CRAFT_PROGRESS = 100;
    private final ActionMap actions = ActionMap.create();
    private static final SlotSemantic[] SLOT = new SlotSemantic[]{ExSemantics.EX_1, ExSemantics.EX_2, ExSemantics.EX_3, ExSemantics.EX_4, ExSemantics.EX_5, ExSemantics.EX_6, ExSemantics.EX_7, ExSemantics.EX_8};
    private final TileExMolecularAssembler molecularAssembler;
    private final List<AppEngSlot> outputs = new ArrayList<AppEngSlot>();
    @GuiSync(value=4)
    public int craftProgress = 0;
    @GuiSync(value=7)
    public int page = 0;

    public ContainerExMolecularAssembler(int id, Inventory ip, TileExMolecularAssembler host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.actions.put("show", o -> this.showPage());
        this.molecularAssembler = host;
        for (int i = 0; i < 8; ++i) {
            InternalInventory inv = this.molecularAssembler.getCraftInventory(i);
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new ExMolecularAssemblerPatternSlot(this, inv, j), SLOT[i]);
            }
            this.outputs.add((AppEngSlot)this.addSlot((Slot)new OutputSlot(inv, 9, null), SlotSemantics.MACHINE_OUTPUT));
        }
    }

    public void showPage() {
        for (int x = 0; x < 8; ++x) {
            for (Slot slot : this.getSlots(SLOT[x])) {
                if (!(slot instanceof AppEngSlot)) continue;
                AppEngSlot as = (AppEngSlot)slot;
                as.setSlotEnabled(this.page == x);
            }
            this.outputs.get(x).setSlotEnabled(this.page == x);
        }
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack i) {
        IMolecularAssemblerSupportedPattern details = this.molecularAssembler.getCurrentPattern(this.page);
        if (details != null) {
            return details.isItemValid(slotIndex, AEItemKey.of((ItemStack)i), this.molecularAssembler.getLevel());
        }
        return false;
    }

    public void broadcastChanges() {
        this.craftProgress = this.molecularAssembler.getCraftingProgress(this.page);
        this.standardDetectAndSendChanges();
    }

    public int getCurrentProgress() {
        return this.craftProgress;
    }

    public int getMaxProgress() {
        return 100;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }

    public static class ExMolecularAssemblerPatternSlot
    extends AppEngSlot
    implements IOptionalSlot {
        private final ContainerExMolecularAssembler mac;

        public ExMolecularAssemblerPatternSlot(ContainerExMolecularAssembler mac, InternalInventory inv, int invSlot) {
            super(inv, invSlot);
            this.mac = mac;
        }

        public boolean mayPlace(ItemStack stack) {
            return super.mayPlace(stack) && this.mac.isValidItemForSlot(this.getSlotIndex(), stack);
        }

        protected boolean getCurrentValidationState() {
            ItemStack stack = this.getItem();
            return stack.isEmpty() || this.mayPlace(stack);
        }

        public boolean isRenderDisabled() {
            return true;
        }

        public boolean isSlotEnabled() {
            if (!this.getInventory().getStackInSlot(this.getSlotIndex()).isEmpty()) {
                return true;
            }
            IMolecularAssemblerSupportedPattern pattern = ((TileExMolecularAssembler)this.mac.getHost()).getCurrentPattern(this.mac.page);
            return this.getSlotIndex() >= 0 && this.getSlotIndex() < 9 && pattern != null && pattern.isSlotEnabled(this.getSlotIndex());
        }

        public Point getBackgroundPos() {
            return new Point(this.x - 1, this.y - 1);
        }
    }
}

