/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.recipe.CrystalFixerRecipeSerializer;
import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CrystalFixerRecipe
implements Recipe<RecipeInput> {
    public static final ResourceLocation ID = ExtendedAE.id("crystal_fixer");
    public static final RecipeType<CrystalFixerRecipe> TYPE = RecipeType.simple((ResourceLocation)ID);
    public static final int FULL_CHANCE = 10000;
    protected final Block input;
    protected final Block output;
    protected final int chance;
    protected final IngredientStack.Item fuel;

    public CrystalFixerRecipe(ItemStack input, ItemStack output, IngredientStack.Item fuel, int chance) {
        this(CrystalFixerRecipe.asBlock(input), CrystalFixerRecipe.asBlock(output), fuel, chance);
    }

    public CrystalFixerRecipe(Block input, Block output, IngredientStack.Item fuel, int chance) {
        this.input = input;
        this.output = output;
        this.fuel = fuel;
        this.chance = chance;
    }

    private static Block asBlock(ItemStack stack) {
        return ((BlockItem)stack.getItem()).getBlock();
    }

    public boolean roll(RandomSource random) {
        if (this.chance == 10000) {
            return true;
        }
        return random.nextInt(10000) < this.chance;
    }

    public double getChance() {
        return (double)this.chance / 10000.0;
    }

    public Block getOutput() {
        return this.output;
    }

    public Block getInput() {
        return this.input;
    }

    public IngredientStack.Item getFuel() {
        return this.fuel.sample();
    }

    public boolean matches(@NotNull RecipeInput pContainer, @NotNull Level pLevel) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput pContainer, @NotNull HolderLookup.Provider pRegistryAccess) {
        return this.getResultItem(pRegistryAccess).copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider pRegistryAccess) {
        return new ItemStack((ItemLike)this.output);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return CrystalFixerRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isSpecial() {
        return true;
    }
}

