/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.xmod.rei.recipes;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipe;
import com.glodblock.github.extendedae.xmod.rei.recipes.REIStackUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class REICrystalAssemblerDisplay
implements Display {
    public static final CategoryIdentifier<REICrystalAssemblerDisplay> ID = CategoryIdentifier.of((ResourceLocation)ExtendedAE.id("rei_crystal_assembler"));
    private final RecipeHolder<CrystalAssemblerRecipe> holder;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final List<EntryIngredient> combined;
    private final EntryIngredient fluid;

    public REICrystalAssemblerDisplay(RecipeHolder<CrystalAssemblerRecipe> holder) {
        this.holder = holder;
        CrystalAssemblerRecipe recipe = (CrystalAssemblerRecipe)holder.value();
        this.inputs = recipe.getInputs().stream().map(REIStackUtil::of).filter(o -> !o.isEmpty()).toList();
        this.fluid = recipe.getFluid() != null ? REIStackUtil.of(recipe.getFluid()) : EntryIngredient.empty();
        this.outputs = ImmutableList.of((Object)EntryIngredients.of((ItemStack)recipe.output));
        this.combined = new ArrayList<EntryIngredient>(this.inputs);
        if (!this.fluid.isEmpty()) {
            this.combined.addLast(this.fluid);
        }
    }

    public List<EntryIngredient> getInputItems() {
        return this.inputs;
    }

    public EntryIngredient getInputFluid() {
        return this.fluid;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.combined;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ID;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.holder.id());
    }
}

