/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.enums.HugeLilypadPiece;

public class HugeLilyPadBlock
extends WaterlilyBlock {
    public static final DirectionProperty FACING = TFHorizontalBlock.FACING;
    public static final EnumProperty<HugeLilypadPiece> PIECE = EnumProperty.create((String)"piece", HugeLilypadPiece.class);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private boolean isSelfDestructing = false;

    public HugeLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PIECE, (Comparable)((Object)HugeLilypadPiece.NW)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PIECE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.isSelfDestructing) {
            this.setGiantBlockToAir(level, pos, state);
        }
    }

    private void setGiantBlockToAir(Level level, BlockPos pos, BlockState state) {
        this.isSelfDestructing = true;
        for (BlockPos check : this.getAllMyBlocks(pos, state)) {
            BlockState stateThere = level.getBlockState(check);
            if (stateThere.getBlock() != this) continue;
            level.destroyBlock(check, false);
        }
        this.isSelfDestructing = false;
    }

    public List<BlockPos> getAllMyBlocks(BlockPos pos, BlockState state) {
        ArrayList pieces = Lists.newArrayListWithCapacity((int)4);
        if (state.getBlock() == this) {
            BlockPos nwPos = switch ((HugeLilypadPiece)((Object)state.getValue(PIECE))) {
                case HugeLilypadPiece.NE -> pos.west();
                case HugeLilypadPiece.SE -> pos.north().west();
                case HugeLilypadPiece.SW -> pos.north();
                default -> pos;
            };
            pieces.add(nwPos);
            pieces.add(nwPos.south());
            pieces.add(nwPos.east());
            pieces.add(nwPos.south().east());
        }
        return pieces;
    }
}

