/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFConfiguredFeatures;

public class MushgloomBlock
extends MushroomBlock {
    private static final VoxelShape MUSHGLOOM_SHAPE = MushgloomBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);

    public MushgloomBlock(BlockBehaviour.Properties properties) {
        super(TFConfiguredFeatures.BIG_MUSHGLOOM, properties);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.below()).isFaceSturdy((BlockGetter)reader, pos, Direction.UP) || reader.getBlockState(pos.below()).is(TFBlocks.UBEROUS_SOIL);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return MUSHGLOOM_SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader getter, BlockPos pos, BlockState state) {
        return false;
    }
}

