/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class SpecialMagicLogBlock
extends RotatedPillarBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    protected SpecialMagicLogBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f).sound(SoundType.WOOD).lightLevel(state -> (Boolean)state.getValue((Property)ACTIVE) != false ? 15 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{ACTIVE}));
    }

    public int tickRate() {
        return 20;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, this.tickRate());
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue() || !this.doesCoreFunction()) {
            return;
        }
        this.playSound((Level)level, pos, rand);
        this.performTreeEffect(level, pos, rand);
        level.scheduleTick(pos, (Block)this, this.tickRate());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!this.doesCoreFunction()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            player.displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.core_disabled", (Object[])new Object[]{this.getName()}).withStyle(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(pos, (Block)this, this.tickRate());
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    abstract void performTreeEffect(ServerLevel var1, BlockPos var2, RandomSource var3);

    public abstract boolean doesCoreFunction();

    protected void playSound(Level level, BlockPos pos, RandomSource rand) {
    }
}

