/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.entity.monster.Wraith;

public class WraithModel
extends HumanoidModel<Wraith> {
    private final ModelPart dress;

    public WraithModel(ModelPart root) {
        super(root, RenderType::entityTranslucent);
        this.dress = root.getChild("dress");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("dress", CubeListBuilder.create().texOffs(40, 16).addBox(-4.0f, 12.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.hat);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.dress);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        super.renderToBuffer(stack, consumer, light, overlay, FastColor.ARGB32.color((int)((int)((float)FastColor.ARGB32.alpha((int)color) * 0.6f)), (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color)));
    }

    public void setupAnim(Wraith entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float var8 = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float var9 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.yRot = -(0.1f - var8 * 0.6f);
        this.leftArm.yRot = 0.1f - var8 * 0.6f;
        this.rightArm.xRot = -1.5707964f;
        this.leftArm.xRot = -1.5707964f;
        this.rightArm.xRot -= var8 * 1.2f - var9 * 0.4f;
        this.leftArm.xRot -= var8 * 1.2f - var9 * 0.4f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
    }
}

