/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SpawnerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import twilightforest.block.entity.spawner.SinisterSpawnerBlockEntity;
import twilightforest.block.entity.spawner.SinisterSpawnerLogic;

@OnlyIn(value=Dist.CLIENT)
public class SinisterSpawnerRenderer
implements BlockEntityRenderer<SinisterSpawnerBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public SinisterSpawnerRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(SinisterSpawnerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        SinisterSpawnerLogic basespawner;
        Entity entity;
        Level level = blockEntity.getLevel();
        if (level != null && (entity = (basespawner = blockEntity.getSpawner()).getOrCreateDisplayEntity(level, blockEntity.getBlockPos())) != null) {
            SpawnerRenderer.renderEntityInSpawner((float)partialTick, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (Entity)entity, (EntityRenderDispatcher)this.entityRenderer, (double)basespawner.getoSpin(), (double)basespawner.getSpin());
        }
    }

    public AABB getRenderBoundingBox(SinisterSpawnerBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 1.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 2.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 2.0);
    }
}

