/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.components.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class OreScannerComponent {
    public static Codec<OreScannerComponent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BlockPos.CODEC.fieldOf("origin").forGetter(s -> s.origin), (App)Codec.INT.fieldOf("span_x").forGetter(s -> s.xSpan), (App)Codec.INT.fieldOf("span_z").forGetter(s -> s.zSpan), (App)Codec.INT.fieldOf("duration").forGetter(s -> s.scanDurationTicks), (App)Codec.unboundedMap((Codec)BuiltInRegistries.BLOCK.byNameCodec(), (Codec)Codec.INT).xmap(Object2IntArrayMap::new, Function.identity()).fieldOf("counts").forGetter(s -> s.blockCounter), (App)Codec.INT.fieldOf("progression").forGetter(s -> s.ticksProgressed)).apply((Applicative)inst, OreScannerComponent::new)).orElseGet(OreScannerComponent::getEmpty);
    private static final OreScannerComponent EMPTY = new OreScannerComponent(BlockPos.ZERO, 0, 0, 0, 0);
    private final int xSpan;
    private final int zSpan;
    private final int area;
    private final int scanDurationTicks;
    private final BlockPos origin;
    private final Object2IntMap<Block> blockCounter;
    private final int ticksProgressed;

    public static OreScannerComponent scanFromCenter(BlockPos center, int range, int scanDurationTicks) {
        int xChunkCenter = center.getX() >> 4;
        int zChunkCenter = center.getZ() >> 4;
        BlockPos origin = new BlockPos(SectionPos.sectionToBlockCoord((int)(xChunkCenter - range)), 0, SectionPos.sectionToBlockCoord((int)(zChunkCenter - range)));
        int xSpan = SectionPos.sectionToBlockCoord((int)(xChunkCenter + range), (int)15) - origin.getX();
        int zSpan = SectionPos.sectionToBlockCoord((int)(zChunkCenter + range), (int)15) - origin.getZ();
        return new OreScannerComponent(origin, xSpan, zSpan, scanDurationTicks, 0);
    }

    public OreScannerComponent(BlockPos origin, int xSpan, int zSpan, int scanDurationTicks, int ticksProgressed) {
        this(origin, xSpan, zSpan, scanDurationTicks, (Object2IntMap<Block>)(xSpan * zSpan <= 0 ? Object2IntMaps.emptyMap() : new Object2IntArrayMap()), ticksProgressed);
    }

    public OreScannerComponent(BlockPos origin, int xSpan, int zSpan, int scanDurationTicks, Object2IntMap<Block> blockCounter, int ticksProgressed) {
        this.origin = origin;
        this.xSpan = xSpan;
        this.zSpan = zSpan;
        this.area = this.xSpan * this.zSpan;
        this.scanDurationTicks = scanDurationTicks;
        this.blockCounter = Object2IntMaps.unmodifiable(blockCounter.isEmpty() ? Object2IntMaps.emptyMap() : blockCounter);
        this.ticksProgressed = ticksProgressed;
    }

    public OreScannerComponent tickScan(BlockGetter reader) {
        BlockPos originPos = this.origin.atY(reader.getMinBuildHeight());
        int volume = this.area * reader.getMaxBuildHeight();
        int march = Mth.ceil((float)((float)volume / (float)Mth.abs((int)this.scanDurationTicks)));
        int totalProgress = this.ticksProgressed * march;
        Object2IntArrayMap nextCounter = new Object2IntArrayMap(this.blockCounter);
        for (int scanSteps = 0; scanSteps < march && totalProgress + scanSteps < volume; ++scanSteps) {
            int xDelta = (totalProgress + scanSteps) % this.xSpan;
            int zDelta = (totalProgress + scanSteps) % (this.xSpan * this.zSpan) / this.xSpan;
            int yDelta = (totalProgress + scanSteps) / (this.xSpan * this.zSpan);
            BlockPos pos = originPos.offset(xDelta, yDelta, zDelta);
            Block blockFound = reader.getBlockState(pos).getBlock();
            nextCounter.put((Object)blockFound, 1 + nextCounter.getOrDefault((Object)blockFound, 0));
        }
        return new OreScannerComponent(this.origin, this.xSpan, this.zSpan, this.scanDurationTicks, (Object2IntMap<Block>)nextCounter, this.ticksProgressed + 1);
    }

    public Map<String, Integer> getResults(@Nullable Block assignedBlock) {
        if (assignedBlock != null) {
            return ImmutableMap.of((Object)assignedBlock.getDescriptionId(), (Object)this.blockCounter.getOrDefault((Object)assignedBlock, 0));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object2IntMap.Entry entry : this.blockCounter.object2IntEntrySet()) {
            if (entry.getIntValue() <= 0 || !((Block)entry.getKey()).builtInRegistryHolder().is(Tags.Blocks.ORES)) continue;
            builder.put((Object)((Block)entry.getKey()).getDescriptionId(), (Object)entry.getIntValue());
        }
        return builder.build();
    }

    public int getVolume(BlockGetter reader) {
        return this.area * reader.getMaxBuildHeight();
    }

    public int getTickProgress() {
        return this.ticksProgressed;
    }

    public ChunkPos centerChunkPos() {
        return new ChunkPos(Mth.floor((float)((float)this.origin.getX() + (float)this.xSpan / 2.0f)) >> 4, Mth.floor((float)((float)this.origin.getZ() + (float)this.zSpan / 2.0f)) >> 4);
    }

    public boolean isEmpty() {
        return this.area <= 0;
    }

    public static OreScannerComponent getEmpty() {
        return EMPTY;
    }

    public boolean isFinished() {
        return this.isEmpty() || this.ticksProgressed >= this.scanDurationTicks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OreScannerComponent that = (OreScannerComponent)o;
        return this.xSpan == that.xSpan && this.zSpan == that.zSpan && this.scanDurationTicks == that.scanDurationTicks && this.ticksProgressed == that.ticksProgressed && Objects.equals(this.origin, that.origin) && Objects.equals(this.blockCounter, that.blockCounter);
    }

    public int hashCode() {
        return Objects.hash(this.xSpan, this.zSpan, this.scanDurationTicks, this.origin, this.blockCounter, this.ticksProgressed);
    }

    public String toString() {
        return "OreScannerComponent{xSpan=" + this.xSpan + ", zSpan=" + this.zSpan + ", area=" + this.area + ", scanDurationTicks=" + this.scanDurationTicks + ", origin=" + String.valueOf(this.origin) + ", blockCounter=" + String.valueOf(this.blockCounter) + ", ticksProgressed=" + this.ticksProgressed + "}";
    }
}

