/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.goal.HoverBeamGoal;
import twilightforest.entity.ai.goal.HoverSummonGoal;
import twilightforest.entity.ai.goal.HoverThenDropGoal;
import twilightforest.entity.boss.BaseTFBoss;
import twilightforest.entity.boss.SnowQueenIceShield;
import twilightforest.entity.monster.IceCrystal;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.util.WorldUtil;
import twilightforest.util.entities.EntityUtil;

public class SnowQueen
extends BaseTFBoss
implements IBreathAttacker {
    private static final int MAX_SUMMONS = 6;
    private static final EntityDataAccessor<Boolean> BEAM_FLAG = SynchedEntityData.defineId(SnowQueen.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> PHASE_FLAG = SynchedEntityData.defineId(SnowQueen.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public final SnowQueenIceShield[] iceArray = new SnowQueenIceShield[7];
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;

    public SnowQueen(EntityType<? extends SnowQueen> type, Level level) {
        super(type, level);
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new SnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.xpReward = 317;
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.setNoGravity(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new HoverSummonGoal(this));
        this.goalSelector.addGoal(2, (Goal)new HoverThenDropGoal(this, 80, 20));
        this.goalSelector.addGoal(3, (Goal)new HoverBeamGoal(this, 80, 100));
        this.addRestrictionGoals((PathfinderMob)this, this.goalSelector);
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean isPushable() {
        return false;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.FLYING_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MAX_HEALTH, 200.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.75);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BEAM_FLAG, (Object)false);
        builder.define(PHASE_FLAG, (Object)0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.SNOW_QUEEN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.SNOW_QUEEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.SNOW_QUEEN_DEATH.get();
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            float px = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
            float py = this.getEyeHeight() + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f;
            float pz = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
            this.level().addParticle((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), this.xOld + (double)px, this.yOld + (double)py, this.zOld + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.getCurrentPhase() == Phase.DROP) {
            for (SnowQueenIceShield ice : this.iceArray) {
                float px = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f;
                float py = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f;
                float pz = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f;
                this.level().addParticle((ParticleOptions)TFParticleType.SNOW_WARNING.get(), ((Entity)ice).xOld + (double)px, ((Entity)ice).yOld + (double)py, ((Entity)ice).zOld + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.isBreathing() && this.isAlive()) {
            Vec3 look = this.getLookAngle();
            double dist = 0.5;
            double px = this.getX() + look.x() * dist;
            double py = this.getY() + (double)1.7f + look.y() * dist;
            double pz = this.getZ() + look.z() * dist;
            for (int i = 0; i < 10; ++i) {
                double dx = look.x();
                double dy = 0.0;
                double dz = look.z();
                double spread = 2.0 + this.getRandom().nextDouble() * 2.5;
                double velocity = 2.0 + this.getRandom().nextDouble() * 0.15;
                dx += this.getRandom().nextGaussian() * 0.0075 * spread;
                dy += this.getRandom().nextGaussian() * 0.0075 * spread;
                dz += this.getRandom().nextGaussian() * 0.0075 * spread;
                this.level().addParticle((ParticleOptions)TFParticleType.ICE_BEAM.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void tick() {
        this.setDeltaMovement(this.getDeltaMovement().x(), this.getDeltaMovement().y() - 0.05, this.getDeltaMovement().z());
        super.tick();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].tick();
            if (i < this.iceArray.length - 1) {
                Vec3 blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].setPos(blockPos.x(), blockPos.y(), blockPos.z());
            } else {
                this.iceArray[i].setPos(this.getX(), this.getY() - 1.0, this.getZ());
            }
            this.iceArray[i].setYRot(this.getIceShieldAngle(i));
            if (this.level().isClientSide()) continue;
            this.applyShieldCollisions((Entity)this.iceArray[i]);
        }
        if (this.deathTime > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.getRandom().nextGaussian() * 0.02;
                double d1 = this.getRandom().nextGaussian() * 0.02;
                double d2 = this.getRandom().nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)(this.getRandom().nextBoolean() ? ParticleTypes.EXPLOSION : ParticleTypes.POOF), this.getX() + (double)(this.getRandom().nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.getRandom().nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.getRandom().nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d, d1, d2);
            }
        }
    }

    private void applyShieldCollisions(Entity collider) {
        List list = this.level().getEntities(collider, collider.getBoundingBox().inflate((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (Entity collided : list) {
            if (!collided.isPushable()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    private void applyShieldCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.push(collider);
            if (collided instanceof LivingEntity && this.doHurtTarget(collided)) {
                Vec3 motion = collided.getDeltaMovement();
                collided.setDeltaMovement(motion.x(), motion.y() + 0.4, motion.z());
                this.playSound((SoundEvent)TFSounds.SNOW_QUEEN_ATTACK.get(), 1.0f, 1.0f);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        DamageSource source = this.getCurrentPhase() == Phase.DROP ? TFDamageTypes.getEntityDamageSource(this.level(), TFDamageTypes.SQUISH, (Entity)this, (EntityType)TFEntities.SNOW_QUEEN.get()) : this.level().damageSources().mobAttack((LivingEntity)this);
        return EntityUtil.properlyApplyCustomDamageSource((Mob)this, entity, source, null);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.getCurrentPhase() == Phase.SUMMON && this.getSummonsRemaining() == 0 && this.countMyMinions() <= 0) {
            this.setCurrentPhase(Phase.DROP);
        }
        if (this.getCurrentPhase() == Phase.DROP && this.successfulDrops >= this.maxDrops) {
            this.setCurrentPhase(Phase.BEAM);
        }
        if (this.getCurrentPhase() == Phase.BEAM && this.damageWhileBeaming >= 25) {
            this.setCurrentPhase(Phase.SUMMON);
        }
    }

    public boolean hurt(DamageSource source, float damage) {
        boolean result = super.hurt(source, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming += (int)damage;
        }
        return result;
    }

    private Vec3 getIceShieldPosition(int idx) {
        return this.getIceShieldPosition(this.getIceShieldAngle(idx), 1.0f);
    }

    private float getIceShieldAngle(int idx) {
        return 60.0f * (float)idx + (float)this.tickCount * 5.0f;
    }

    private Vec3 getIceShieldPosition(float angle, float distance) {
        double dx = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3(this.getX() + dx, this.getY() + this.getShieldYOffset(), this.getZ() + dz);
    }

    private double getShieldYOffset() {
        return 0.1f;
    }

    public void destroyBlocksInAABB(AABB box) {
        if (EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            for (BlockPos pos : WorldUtil.getAllInBB(box)) {
                BlockState state = this.level().getBlockState(pos);
                if (!state.is(BlockTags.ICE)) continue;
                this.level().destroyBlock(pos, false);
                this.gameEvent((Holder)GameEvent.BLOCK_DESTROY);
            }
        }
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.getEntityData().get(BEAM_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.getEntityData().set(BEAM_FLAG, (Object)flag);
    }

    public Phase getCurrentPhase() {
        return Phase.values()[(Byte)this.getEntityData().get(PHASE_FLAG)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.getEntityData().set(PHASE_FLAG, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.getRandom().nextInt(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void summonMinionAt(LivingEntity targetedEntity) {
        IceCrystal minion = new IceCrystal(this.level());
        minion.absMoveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
        this.level().addFreshEntity((Entity)minion);
        for (int i = 0; i < 100; ++i) {
            double attemptZ;
            double attemptY;
            double attemptX;
            if (this.isRestrictionPointValid(this.level().dimension())) {
                BlockPos home = this.getRestrictionPoint().pos();
                attemptX = (double)home.getX() + this.getRandom().nextGaussian() * 3.0;
                attemptY = (double)home.getY() + this.getRandom().nextGaussian() * 2.0;
                attemptZ = (double)home.getZ() + this.getRandom().nextGaussian() * 3.0;
            } else {
                attemptX = targetedEntity.getX() + this.getRandom().nextGaussian() * 6.0;
                attemptY = targetedEntity.getY() + this.getRandom().nextGaussian() * 8.0;
                attemptZ = targetedEntity.getZ() + this.getRandom().nextGaussian() * 6.0;
            }
            if (!minion.randomTeleport(attemptX, attemptY, attemptZ, true)) continue;
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)minion);
            break;
        }
        minion.setTarget(targetedEntity);
        minion.setToDieIn30Seconds();
        --this.summonsRemaining;
    }

    public int countMyMinions() {
        return this.level().getEntitiesOfClass(IceCrystal.class, new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate(32.0, 16.0, 32.0)).size();
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.hurt(TFDamageTypes.getEntityDamageSource(this.level(), TFDamageTypes.CHILLING_BREATH, (Entity)this, (EntityType)TFEntities.SNOW_QUEEN.get()), 4.0f);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        TFPart.assignPartIDs((Entity)this);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.iceArray;
    }

    @Override
    public int getHomeRadius() {
        return 20;
    }

    @Override
    public ResourceKey<Structure> getHomeStructure() {
        return TFStructures.AURORA_PALACE;
    }

    @Override
    public Block getDeathContainer(RandomSource random) {
        return (Block)TFBlocks.TWILIGHT_OAK_CHEST.get();
    }

    @Override
    public Block getBossSpawner() {
        return (Block)TFBlocks.SNOW_QUEEN_BOSS_SPAWNER.get();
    }

    @Override
    public int getBossBarColor() {
        return 9236720;
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

